package cn.pengh.core.rpc;

import cn.pengh.core.data.res.IRestResData;
import cn.pengh.helper.JavaMethodBuilderHelper;

import java.math.BigInteger;

/**
 * 
 * @author pengh
 * @Date 2016年9月28日 上午11:11:13
 */
public class PayResponse extends DubboResponse implements IRestResData {
	private static final long serialVersionUID = 8646307739324481402L;
	private String orderNo;//电商支付订单号
	private String payOrderNo;//渠道支付订单号，比如支付宝、微信支付订单
	private String outOrderNo;//外部订单号，比如上送的承包订单号
	private String body;//支付宝类，预支付参数
	private String qrCodeUrl;//扫码支付，返回的二维码短链接
	private long tradeAmt;//交易金额
	private BigInteger availableBalance;//可用余额

	public PayResponse(int code, String desc) {
		super(code, desc);
	}

	/* auto generated by penghcn 2018/09/21 14:05:29.708 */
	public PayResponse setOrderNo(String orderNo) {
		this.orderNo = orderNo;
		return this;
	}
	public String getOrderNo() {
		return this.orderNo;
	}
	public PayResponse setPayOrderNo(String payOrderNo) {
		this.payOrderNo = payOrderNo;
		return this;
	}
	public String getPayOrderNo() {
		return this.payOrderNo;
	}
	public PayResponse setOutOrderNo(String outOrderNo) {
		this.outOrderNo = outOrderNo;
		return this;
	}
	public String getOutOrderNo() {
		return this.outOrderNo;
	}
	public PayResponse setBody(String body) {
		this.body = body;
		return this;
	}
	public String getBody() {
		return this.body;
	}
	public PayResponse setQrCodeUrl(String qrCodeUrl) {
		this.qrCodeUrl = qrCodeUrl;
		return this;
	}
	public String getQrCodeUrl() {
		return this.qrCodeUrl;
	}
	public PayResponse setTradeAmt(long tradeAmt) {
		this.tradeAmt = tradeAmt;
		return this;
	}
	public long getTradeAmt() {
		return this.tradeAmt;
	}
	public PayResponse setAvailableBalance(BigInteger availableBalance) {
		this.availableBalance = availableBalance;
		return this;
	}
	public BigInteger getAvailableBalance() {
		return this.availableBalance;
	}
	public PayResponse (){}
	public static PayResponse createDefault(){
		return new PayResponse();
	}
	public PayResponse build(){
		return new PayResponse(orderNo, payOrderNo, outOrderNo, body,
				qrCodeUrl, tradeAmt, availableBalance);
	}
	private PayResponse (String orderNo, String payOrderNo, String outOrderNo, String body,
						 String qrCodeUrl, long tradeAmt, BigInteger availableBalance) {
		this.orderNo = orderNo;
		this.payOrderNo = payOrderNo;
		this.outOrderNo = outOrderNo;
		this.body = body;
		this.qrCodeUrl = qrCodeUrl;
		this.tradeAmt = tradeAmt;
		this.availableBalance = availableBalance;
	}

	public static void main(String[] args) {
		JavaMethodBuilderHelper.gen(PayResponse.class);
	}
}


