package cn.pengh.core.constant;

public enum ResponseCodeEnum implements IResponseCode {
    SUCCESS(200, "成功"),
    INVALID_PARAM(400, "参数不合法(int,string等)"),
    INVALID_PARAM_NULL(40001, "参数为null"),
    INVALID_PARAM_EMPTY(40001, "参数为空"),
    INVALID_PARAM_LEN(40002, "长度不合适"),
    INVALID_PARAM_MOBILE(40003, "手机号格式不正确"),
    INVALID_PARAM_MAIL(40004, "邮箱地址格式不正确"),
    INVALID_PARAM_CHARSET(40005, "编码不一致(UTF-8)"),
    INVALID_PARAM_CHINESE_MESS(40006, "可能中文乱码"),
    INVALID_PARAM_MONEY(40007, "金额格式不正确"),
    INVALID_PARAM_DIGITS(40008, "数字格式不正确"),
    INVALID_PARAM_CHINESE(40009, "中文字符不正确"),
    INVALID_PARAM_ID_CARD(40010, "身份证格式不正确"),
    INVALID_PARAM_URL(40011, "URL地址格式不正确"),

    INVALID_FUIOU_KMP_BUSI(400105, "该密钥不存在"),
    INVALID_FUIOU_SMS_FREQUENCY_LIMIT(400106, "发送过于频繁，请稍后再试"),
    INVALID_FUIOU_SMS_DAILY_LIMIT(400107, "超过日均发送次数"),

    NO_LOGIN(40101, "未登录或登录凭证(token/session)已过期，请重新登录，谢谢"),
    INVALID_LOGIN_PASS(40102, "账号或密码错误，请重新登录，谢谢"),
    INVALID_LOGIN_PASS_LIMIT(40103, "账号或密码错误次数超限，请联系管理员或明天再试，谢谢"),

    INVALID_CAPTCHA(40301, "验证码(token)错误"),
    INVALID_CAPTCHA_EXPIRE(40302, "验证码(token)不存在或已过期，请重新获取"),
    INVALID_CAPTCHA_LIMIT(40303, "验证码(token)已发送，请稍后再试"),
    INVALID_SIGN(40310, "签名校验错误"),
    INVALID_SIGN_EXPIRE(40310, "签名校验错误，已过期或本地时间有误"),

    INVALID_SIGN_SHA1(40311, "SHA1校验错误"),
    INVALID_SIGN_SHA2(40312, "SHA256校验错误"),
    INVALID_SIGN_SHA3(40313, "SHA384校验错误"),
    INVALID_SIGN_SHA5(40315, "SHA512校验错误"),
    INVALID_SIGN_RSA(40316, "RSA校验错误"),
    INVALID_SIGN_MD5(40317, "MD5校验错误"),
    INVALID_SIGN_HASH(40318, "HASH校验错误"),

    //可用于一般业务场景
    ASYNC_SUCCESS(100200, "成功，异步处理中"),

    ERROR_QOS(429, "QOS限流"),
    ERROR_400(400, "参数异常"),
    ERROR_401(401, "授权异常"),
    ERROR_403(403, "拒绝访问"),
    ERROR_429(429, "QOS限流"),
    ERROR_500(500, "系统异常"),
    ERROR_502(502, "系统繁忙"),
    ERROR_504(504, "系统繁忙"),
    ERROR_503(503, "系统服务不可用");

    private int code;
    private String desc;

    private ResponseCodeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static String getDesc(int code) {
        return get(code).getDesc();
    }


    public static ResponseCodeEnum get(int code) {
        for (ResponseCodeEnum e : ResponseCodeEnum.values()) {
            if (code == e.getCode())
                return e;
        }
        return null;
    }
}
