package cn.pengh.crypt.asymmetric;

import javax.crypto.Cipher;
import javax.crypto.NullCipher;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;

/**
 * 推荐使用bouncycastle库实现 ECC ECDSA
 * static {
 *         Security.addProvider(new org.bouncycastle.jce.provider.BouncyCastleProvider());
 *     }
 * @author Created by pengh
 * @datetime 2021/6/11 11:22
 */
public class SHA256withECDSA extends SHA256WithRSA implements IAsymmetricEncryptor {

    @Override
    protected String getSignType() {
        return AsymmetricFactory.Algorithm.SHA256ECDSA;
    }

    @Override
    protected String getAsymmetricType() {
        return AsymmetricFactory.AsymmetricAlgorithm.EC;
    }
    @Override
    protected String getAsymmetricAlgorithm() {
        return AsymmetricFactory.AsymmetricAlgorithm.EC;
    }

    protected Cipher getPubCipher(PublicKey pubKey2) throws Exception {
        ECPublicKey pubKey = (ECPublicKey) pubKey2;

        Cipher cipher = new NullCipher();
        cipher.init(Cipher.ENCRYPT_MODE, pubKey, new ECPublicKeySpec(pubKey.getW(), pubKey.getParams()).getParams());
        return cipher;
    }

    @Override
    protected Cipher getPriCipher(PrivateKey priKey2) throws Exception {
        ECPrivateKey priKey = (ECPrivateKey) priKey2;

        Cipher cipher = new NullCipher();
        cipher.init(Cipher.DECRYPT_MODE, priKey, new ECPrivateKeySpec(priKey.getS(), priKey.getParams()).getParams());
        return cipher;
    }
}
