package cn.pengh.math;

import java.util.Random;

/**
 * @author penghcn
 * @created 2015年7月16日下午3:21:47
 */
public final class JVMRandom extends Random {
    private static final long serialVersionUID = 901776232865634976L;
    private boolean constructed;

    public JVMRandom() {
        this.constructed = true;
    }

    public synchronized void setSeed(long seed) {
        if (this.constructed)
            throw new UnsupportedOperationException();
    }

    public synchronized double nextGaussian() {
        throw new UnsupportedOperationException();
    }

    public void nextBytes(byte[] byteArray) {
        throw new UnsupportedOperationException();
    }

    public int nextInt() {
        return nextInt(Integer.MAX_VALUE);
    }

    public int nextInt(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Upper bound for nextInt must be positive");
        }

        return (int) (Math.random() * n);
    }

    public long nextLong() {
        return nextLong(Long.MAX_VALUE);
    }

    public static long nextLong(long n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Upper bound for nextInt must be positive");
        }

        return (long) (Math.random() * n);
    }

    public boolean nextBoolean() {
        return (Math.random() > 0.618d);
    }

    public float nextFloat() {
        return (float) Math.random();
    }

    public double nextDouble() {
        return Math.random();
    }
}
