package cn.pengh.core.data.res;

import cn.pengh.core.constant.ResponseCodeEnum;
import com.thoughtworks.xstream.annotations.XStreamAlias;

@XStreamAlias("xml")
public class RestfulResponse {
    private int code;
    private String desc;
    private String sign;
    private String serial;
    private String token;
    private Boolean refreshToken;
    private String expireTs; //到期时间 yyyyMMddHHmmss
    private Long totalCount; //总量
    private IRestResData data;

    /* auto generated by penghcn 20/11/04 17:15:11.707 */
    public RestfulResponse setCode(int code) {
        this.code = code;
        return this;
    }
    public int getCode() {
        return this.code;
    }
    public RestfulResponse setDesc(String desc) {
        this.desc = desc;
        return this;
    }
    public String getDesc() {
        return this.desc;
    }
    public RestfulResponse setSign(String sign) {
        this.sign = sign;
        return this;
    }
    public String getSign() {
        return this.sign;
    }
    public RestfulResponse setSerial(String serial) {
        this.serial = serial;
        return this;
    }
    public String getSerial() {
        return this.serial;
    }
    public RestfulResponse setToken(String token) {
        this.token = token;
        return this;
    }
    public String getToken() {
        return this.token;
    }
    public RestfulResponse setRefreshToken(Boolean refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }
    public Boolean isRefreshToken() {
        return this.refreshToken;
    }
    public RestfulResponse setExpireTs(String expireTs) {
        this.expireTs = expireTs;
        return this;
    }
    public String getExpireTs() {
        return this.expireTs;
    }
    public RestfulResponse setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
        return this;
    }
    public Long getTotalCount() {
        return this.totalCount;
    }
    public RestfulResponse setData(IRestResData data) {
        this.data = data;
        return this;
    }
    public IRestResData getData() {
        return this.data;
    }
    public RestfulResponse() { }
    public static RestfulResponse createDefault() {
        return new RestfulResponse();
    }
    public RestfulResponse build() {
        return new RestfulResponse(code, desc, sign, serial,
                token, refreshToken, expireTs, totalCount,
                data);
    }
    private RestfulResponse(int code, String desc, String sign, String serial,
                            String token, Boolean refreshToken, String expireTs, Long totalCount,
                            IRestResData data) {
        this.code = code;
        this.desc = desc;
        this.sign = sign;
        this.serial = serial;
        this.token = token;
        this.refreshToken = refreshToken;
        this.expireTs = expireTs;
        this.totalCount = totalCount;
        this.data = data;
    }

    public RestfulResponse(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static RestfulResponse create(int code, String desc) {
        return new RestfulResponse(code, desc);
    }

    public boolean isSuccess() {
        return code == ResponseCodeEnum.SUCCESS.getCode();
    }
}
