package cn.pengh.crypt.asymmetric;

import cn.pengh.exception.CustomException;

/**
 * @author Created by pengh
 * @datetime 2021/6/10 15:04
 */
public class AsymmetricFactory {
    private static final class Rsa2LazyHolder {
        private static final SHA256WithRSA INSTANCE = new SHA256WithRSA();
    }
    private static final class Rsa1LazyHolder {
        private static final SHA1WithRSA INSTANCE = new SHA1WithRSA();
    }
    private static final class EcDsaLazyHolder {
        private static final SHA256withECDSA INSTANCE = new SHA256withECDSA();
    }

    public static IAsymmetricEncryptor getByName(String type)  {
        switch (type) {
            case AbstractAsymmetricEncryptor.Algorithm.SHA256RSA:
            case AbstractAsymmetricEncryptor.Algorithm.RSA2:
                return Rsa2LazyHolder.INSTANCE;
            case AbstractAsymmetricEncryptor.Algorithm.SHA128RSA:
            case AbstractAsymmetricEncryptor.Algorithm.RSA:
                return Rsa1LazyHolder.INSTANCE;
            case AbstractAsymmetricEncryptor.Algorithm.SHA256ECDSA:
                return EcDsaLazyHolder.INSTANCE;
            default:
                throw CustomException.create("无效的非对称加密类型:[\" + type + \"]，可选值为：RSA,RSA2,SHA256WithRSA,SHA1WithRSA,SHA256withECDSA");
        }
    }
}
