package cn.pengh.util;

import cn.pengh.core.data.res.GpsRangeRes;
import cn.pengh.library.Log;

/**
 * @author Created by pengh
 * @datetime 2017/9/26 11:50
 */
public class GpsUtil {
    public static final double EA = 6378137;     //   赤道半径 米
    public static final double EB = 6359752;     //   极半径
    public static final double EC = 6370693.5;//(EA + EB) / 2;     // 平均半径

    public static final double A = 6378245.0;

    public static final double EE = 0.00669342162296594323;//椭球的偏心率
    public static final double X_PI = Math.PI * 3000.0 / 180.0;//圆周率转换量

    /**
     * SELECT Id FROM Table WHERE lat >= latMin AND lat < latMax AND lng >= lngMin AND lng < lngMax
     * @param lng
     * @param lat
     * @param distance
     * @return 西经 lngWest，东经 lngEast，南纬 latSouth，北纬 latNorth
     * @return 西经 lngMin，东经 lngMax，南纬 latMin，北纬 latMax
     */
    public static Double[] getRectRange(double lng, double lat, double distance) {
        //顺时针方向
        Double[] north = getLngLat(lng, lat, distance ,0);
        Double[] east = getLngLat(lng, lat, distance ,90);
        Double[] south = getLngLat(lng, lat, distance ,180);
        Double[] west = getLngLat(lng, lat, distance ,270);
        return new Double[]{west[1],east[1],south[0],north[0]};
    }

    public static GpsRangeRes getRectRangeRes(double lng, double lat, double distance) {
        Double[] range = getRectRange(lng,lat,distance);
        return new GpsRangeRes(range[0], range[1], range[2], range[3]);
    }

    /**
     * 2个坐标间距离
     * @param lon1
     * @param lat1
     * @param lon2
     * @param lat2
     * @return
     */
    public static Double getDistance(double lon1, double lat1, double lon2, double lat2) {
        double ew1, ns1, ew2, ns2;
        double distance;
        // 角度转换为弧度
        ew1 = lon1 * Math.PI / 180.0;
        ns1 = lat1 * Math.PI / 180.0;
        ew2 = lon2 * Math.PI / 180.0;
        ns2 = lat2 * Math.PI / 180.0;
        // 求大圆劣弧与球心所夹的角(弧度)
        distance = Math.sin(ns1) * Math.sin(ns2) + Math.cos(ns1) * Math.cos(ns2) * Math.cos(ew1 - ew2);
        // 调整到[-1..1]范围内，避免溢出
        if (distance > 1.0)
            distance = 1.0;
        else if (distance < -1.0)
            distance = -1.0;
        // 求大圆劣弧长度
        distance = EC * Math.acos(distance);
        return distance;
    }

    /**
     * 求方圆几公里内
     * 半径内区域 西东南北经、纬度
     * @param lon
     * @param lat
     * @param r 米
     * @return double[4] 西经 lngWest，东经lngEast，南纬latSouth，北纬latNorth
     */
    public static Double[] getRange(double lon, double lat, double r) {
        Double[] range = new Double[4];
        // 角度转换为弧度
        double ns = lat * Math.PI / 180.0;
        double sinNs = Math.sin(ns);
        double cosNs = Math.cos(ns);
        double cosTmp = Math.cos(r / EC);
        // 经度的差值
        double lonDif = Math.acos((cosTmp - sinNs * sinNs) / (cosNs * cosNs)) / (Math.PI /180.0);
        // 保存经度
        range[0] = lon - lonDif;
        range[1] = lon + lonDif;
        double m = 0 - 2 * cosTmp * sinNs;
        double n = cosTmp * cosTmp - cosNs * cosNs;
        double o1 = (0 - m - Math.sqrt(m * m - 4 * (n))) / 2;
        double o2 = (0 - m + Math.sqrt(m * m - 4 * (n))) / 2;
        // 纬度
        double lat1 = 180 / Math.PI * Math.asin(o1);
        double lat2 = 180 / Math.PI * Math.asin(o2);
        // 保存
        range[2] = lat1;
        range[3] = lat2;
        return range;
    }

    /**
     *
     * @param lng
     * @param lat
     * @param distance m米
     * @param angle 角度
     * @return
     */
    private static Double[] getLngLat(double lng, double lat, double distance, double angle) {
        double dx = distance * Math.sin(angle * Math.PI / 180.0);
        double dy = distance * Math.cos(angle * Math.PI / 180.0);

        double ec = EB + (EA-EB) * (90.0 - lat) / 90.0;
        double ed = ec * Math.cos(lat * Math.PI / 180.0);
        return new Double[]{(dy / ec + lat * Math.PI / 180.0) * 180.0 / Math.PI, (dx / ed + lng * Math.PI / 180.0) * 180.0 / Math.PI};
    }


    /**
     * WGS-84：是国际标准，GPS坐标（Google Earth 谷歌地球使用、或者GPS模块）
     * GCJ-02：中国坐标偏移标准，Google Map谷歌地图、高德、腾讯使用
     * BD-09：百度坐标偏移标准，Baidu Map使用
     * 代码参考：http://bbs.lbsyun.baidu.com/forum.php?mod=viewthread&tid=10923
     * http://lbsyun.baidu.com/index.php?title=webapi/guide/changeposition
     *
     * gps坐标转换成百度坐标，小数点前4位为准确坐标
     */
    public static double[] wgs2bd(double lng, double lat) {
        double[] wgs2gcjs = wgs2gcj(lng, lat);
        double[] gcj2bd = gcj2bd(wgs2gcjs[0], wgs2gcjs[1]);
        return gcj2bd;
    }

    public static double[] bd2gcj(double lng, double lat) {
        double x = lng - 0.0065, y = lat - 0.006;
        double z = Math.sqrt(x * x + y * y) - 0.00002 * Math.sin(y * X_PI);
        double theta = Math.atan2(y, x) - 0.000003 * Math.cos(x * X_PI);
        double gg_lng = z * Math.cos(theta);
        double gg_lat = z * Math.sin(theta);
        return new double[] { gg_lng ,gg_lat};
    }

    public static double[] gcj2bd(double lng, double lat) {
        double x = lng, y = lat;
        double z = Math.sqrt(x * x + y * y) + 0.00002 * Math.sin(y * X_PI);
        double theta = Math.atan2(y, x) + 0.000003 * Math.cos(x * X_PI);
        double bd_lng = z * Math.cos(theta) + 0.0065;
        double bd_lat = z * Math.sin(theta) + 0.006;
        return new double[] {  bd_lng, bd_lat };
    }
    public static double[] wgs2gcj(double lng, double lat) {
        double dLat = transformLat(lat - 35.0, lng - 105.0);
        double dLng = transformLng(lat - 35.0, lng - 105.0);
        double radLat = lat / 180.0 * Math.PI;
        double magic = Math.sin(radLat);
        magic = 1 - EE * magic * magic;
        double sqrtMagic = Math.sqrt(magic);
        dLat = (dLat * 180.0) / ((EA * (1 - EE)) / (magic * sqrtMagic) * Math.PI);
        dLng = (dLng * 180.0) / (EA / sqrtMagic * Math.cos(radLat) * Math.PI);
        double mgLat = lat + dLat;
        double mgLng = lng + dLng;
        return new double[] { mgLng, mgLat };
    }

    private static double transformLng(double lng, double lat) {
        double ret = 300.0 + lat + 2.0 * lng + 0.1 * lat * lat + 0.1 * lat * lng + 0.1 * Math.sqrt(Math.abs(lat));
        ret += (20.0 * Math.sin(6.0 * lat * Math.PI) + 20.0 * Math.sin(2.0 * lat * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(lat * Math.PI) + 40.0 * Math.sin(lat / 3.0 * Math.PI)) * 2.0 / 3.0;
        ret += (150.0 * Math.sin(lat / 12.0 * Math.PI) + 300.0 * Math.sin(lat / 30.0 * Math.PI)) * 2.0 / 3.0;
        return ret;
    }

    private static double transformLat(double lng, double lat) {
        double ret = -100.0 + 2.0 * lat + 3.0 * lng + 0.2 * lng * lng + 0.1 * lat * lng + 0.2 * Math.sqrt(Math.abs(lat));
        ret += (20.0 * Math.sin(6.0 * lat * Math.PI) + 20.0 * Math.sin(2.0 * lat * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(lng * Math.PI) + 40.0 * Math.sin(lng / 3.0 * Math.PI)) * 2.0 / 3.0;
        ret += (160.0 * Math.sin(lng / 12.0 * Math.PI) + 320 * Math.sin(lng * Math.PI  / 30.0)) * 2.0 / 3.0;
        return ret;
    }

    public static void main(String[] args) {
        /*double lng = 121.55711567154,lat = 31.230286683682,radius = 1500;
        Log.error(Arrays.asList(getRectRange(lng,lat,radius)));
        Log.error(Arrays.asList(getRange(lng,lat,radius)));
        Log.error(getDistance(lng,lat,121.54133900684292,lat));

        Double[] range = getRectRange(lng,lat,radius);
        String rangeStr = "";
        for (int i = 0; i < 4; i++) {
            Log.debug(range[i]);
            rangeStr += range[i]+",";
        }

        Log.error("https://passet.com.cn/gps_bmap.html?center="+lng+","+lat
                +"&range="+ rangeStr);*/
        t();
    }

    private static  void t() {
        double lng = 121.56127223574,lat = 31.228305327673, radius = 1500;
        //121.56127223574000,31.228305327673000,121.56127223574000
        //121.57194893048572,31.232489699094920,121.57194893048572
        //121.56972838212039,31.235480277303484,121.56972838212039
        //121.56330132356214,31.229116051298437,121.56330132356214

        lat = 31.2242575875;
        lng = 121.5509207687;

        //31.230586558692654,121.55735598438898
        //31.2306170000,121.5573540000
        double[] gc = gcj2bd(lng,lat);//对了
        Log.error("gcj2bd，"+gc[0]+","+ gc[1]+","+ gc[0]);



        lat = 31.2306170000;
        lng = 121.5573540000;

        //31.22428858736405,121.55091852932198
        //31.2242575875,121.5509207687
        double[] bd2gcj = bd2gcj(lng,lat);//对了
        Log.error("bd2gcj，"+bd2gcj[0]+","+ bd2gcj[1]+","+ bd2gcj[0]);

        //31.2306170000,121.5573540000


        lat = 31.2242723260; lng = 121.5509258799;//31.228476891625449,121.5616236940006
        //31.231432340475262,121.55938809579995
        //31.228472734177824,121.56161872433101 (参考值)
        //31.2306170000,121.5573540000
        double[] bd = wgs2bd(lng,lat);
        Log.error(bd[0]+","+ bd[1]+","+ bd[0]);

        //31.222115007253205,121.55519169476705
        //31.2221173160,121.5551977299
        double[] gd = wgs2gcj(lng,lat);

        Log.error(gd[0]+","+ gd[1]+","+ gd[0]);
    }


}
