package cn.pengh.library;


import cn.pengh.util.DateUtil;

import cn.pengh.util.StringUtil;
import java.io.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 根据java field拼成java method
 * @author penghcn
 * @created 2016年2月2日下午4:53:44
 */
public class JavaMethodBuilder {
	private StringBuilder sb = new StringBuilder();
	private String clazzName;
	private boolean isGetInterface;
	private boolean isCurrencyYuan;
	private boolean isReturnThis;
	private boolean isConstruct;
	private boolean isGet;

	
	public String parseFile(File file){
		sb.append("/* auto generated by penghcn "+DateUtil.getCurrDay(DateUtil.FORMAT_LOG)+" */");
		sb.append(System.getProperty("line.separator"));
		
		BufferedReader scan = null;
		try {
			scan = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
			String line = null,fieldType = null,field = null;
			List<String> list = null;
			ArrayList<String> fieldTypes = new ArrayList<String>();
			ArrayList<String> fields = new ArrayList<String>();
			while ((line = scan.readLine()) != null) {	
				if (!(line.indexOf(";") > -1))
					continue;
				list = new ArrayList<>();
				//Log.debug(line);
				for (String s : line.replaceAll(";", "").split(" ")) {
					if (!s.equals(""))
						list.add(s.replaceAll(",", ", ").trim());
				}
				
				//Log.debug(list);
				fieldType = list.get(1);
				field = list.get(2).replaceAll("(.*)=(.*)", "$1").replaceAll("(.*)//(.*)", "$1");
				fieldTypes.add(fieldType);
				fields.add(field);
				
				if (isCurrencyYuan) {
					toCurrencyYuan(fieldType, field);
				}
				if (isReturnThis) {
					toReturnThis(fieldType, field);
				}
				if (isGet) {
					toGet(fieldType, field);
				}
				if (isGetInterface) {
					toGetInterface(fieldType, field);
				}
			}
			if (isConstruct) {
				toConstruct(fields, fieldTypes);
			}
			
			sb.append(System.getProperty("line.separator"));
			scan.close();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if(scan != null)
					scan.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return sb.toString();
	}
	private void toConstruct(ArrayList<String> fields,ArrayList<String> fieldTypes){
		int index = 0, size = fields.size();
		sb.append("public "+clazzName+"() { ")
				//.append(System.getProperty("line.separator"))
				//.append("\t").append("if (getRpcSerial() == null)").append(System.getProperty("line.separator")).append("\t");
				//.append("\t").append("setRpcSerial(SerialUtil.genSerialStr());").append(System.getProperty("line.separator"))
				.append("}").append(System.getProperty("line.separator"));
		sb.append("public static "+clazzName+" createDefault() { ").append(System.getProperty("line.separator"))
			.append("\t").append("return new "+clazzName+"();").append(System.getProperty("line.separator"))
			.append("}").append(System.getProperty("line.separator"));
		sb.append("public "+clazzName+" build() { ").append(System.getProperty("line.separator"))
			.append("\t").append("return new "+clazzName+"(");
		for (String field : fields) {
			sb.append(field);
			if ((++index) < size) {
				sb.append(", ");
			}
			if (index % 4 == 0 && index != size) {
				sb.append(System.getProperty("line.separator")).append("\t").append("\t");
			}
		}
		sb.append(");").append(System.getProperty("line.separator"))
			.append("}").append(System.getProperty("line.separator"));
		
		index = 0;
		sb.append("private "+clazzName+"(");
		for (String field : fields) {
			sb.append(fieldTypes.get(index++)).append(" ").append(field);
			if (index < size) {
				sb.append(", ");
			}
			if (index % 4 == 0 && index != size) {
				sb.append(System.getProperty("line.separator")).append("\t");
			}
		}
		sb.append(") {").append(System.getProperty("line.separator"));
		for (String field : fields) {
			sb.append("\t").append("this."+field+" = "+field+";").append(System.getProperty("line.separator"));
		}
		sb.append("}").append(System.getProperty("line.separator"));
	}
	private void toReturnThis(String fieldType ,String field){
		//set
		sb.append("public "+clazzName+" set"+StringUtil.toCaptureName(
				"boolean".equals(getFieldType(fieldType)) ? field.replaceAll("is(.*)", "$1") : field));		
		sb.append("("+fieldType+" "+field+") {").append(System.getProperty("line.separator"));
		sb.append("\t").append("this."+field+" = "+field+";").append(System.getProperty("line.separator"));
		sb.append("\t").append("return this;").append(System.getProperty("line.separator"));
		sb.append("}").append(System.getProperty("line.separator"));
	}
	private void toGet(String fieldType ,String field){
		//get
		String get = "boolean".equals(getFieldType(fieldType)) ? " is" : " get";
		sb.append("public "+fieldType+get+StringUtil.toCaptureName(
				"boolean".equals(getFieldType(fieldType)) ? field.replaceAll("is(.*)", "$1") : field));	
		sb.append("() {").append(System.getProperty("line.separator"));
		sb.append("\t").append("return this."+field+";").append(System.getProperty("line.separator"));
		sb.append("}").append(System.getProperty("line.separator"));
	}
	private void toGetInterface(String fieldType ,String field){
		//get
		String get = "boolean".equals(getFieldType(fieldType)) ? " is" : " get";
		sb.append("public "+fieldType+get+StringUtil.toCaptureName(
				"boolean".equals(getFieldType(fieldType)) ? field.replaceAll("is(.*)", "$1") : field));	
		sb.append("();").append(System.getProperty("line.separator"));
	}
	private void toCurrencyYuan(String fieldType ,String field){
		//set
		sb.append("@CurrencyMethod ");
		sb.append(System.getProperty("line.separator"));
		sb.append("public void set"+StringUtil.toCaptureName(field)+"Yuan");
		sb.append("(String "+field+") {");
		sb.append(System.getProperty("line.separator")).append("\t");
		sb.append("this."+field+" = CurrencyUtil.yuan2fen("+field+").")
			.append(getFieldType(fieldType)+"Value();");
		sb.append(System.getProperty("line.separator"))
			.append("}").append(System.getProperty("line.separator"));
		
		//get
		sb.append("@CurrencyMethod ");
		sb.append(System.getProperty("line.separator"));
		sb.append("public String get"+StringUtil.toCaptureName(field)+"Yuan() {");
		sb.append(System.getProperty("line.separator")).append("\t");
		sb.append("return CurrencyUtil.fen2yuanStr("+field+");");
		sb.append(System.getProperty("line.separator"))
			.append("}").append(System.getProperty("line.separator"));
	}
	
	private String getFieldType(String type){
		return "Integer".equals(type) ? "int" : type.toLowerCase();
	}
	
	@SuppressWarnings("unused")
	private static Map<String,String> fieldTypeMap = new HashMap<String, String>(){
		private static final long serialVersionUID = 7243153239082052374L;{
			put("long","long");
			put("Long","long");
			put("int","int");
			put("Integer","int");
			put("short","short");
			put("Short","short");
			put("byte","byte");
			put("Byte","byte");
			put("double","double");
			put("Double","double");
		}
	};
	
	/* auto generated by penghcn 2016-02-14 11:01:14 */
	public JavaMethodBuilder setSb(StringBuilder sb) {
		this.sb = sb;
		return this;
	}
	public JavaMethodBuilder setClazzName(String clazzName) {
		this.clazzName = clazzName;
		return this;
	}
	public JavaMethodBuilder setCurrencyYuan(boolean isCurrencyYuan) {
		this.isCurrencyYuan = isCurrencyYuan;
		return this;
	}
	public JavaMethodBuilder setReturnThis(boolean isReturnThis) {
		this.isReturnThis = isReturnThis;
		return this;
	}
	public JavaMethodBuilder setGetInterface(boolean isGetInterface) {
		this.isGetInterface = isGetInterface;
		return this;
	}
	public JavaMethodBuilder setGet(boolean isGet) {
		this.isGet = isGet;
		return this;
	}
	public JavaMethodBuilder setConstruct(boolean isConstruct) {
		this.isConstruct = isConstruct;
		return this;
	}
	public JavaMethodBuilder (){}
	public static JavaMethodBuilder createDefault(){
		return new JavaMethodBuilder();
	}
	public JavaMethodBuilder build(){
		return new JavaMethodBuilder(sb, clazzName, isCurrencyYuan, isReturnThis, 
			isConstruct,isGetInterface,isGet);
	}
	private JavaMethodBuilder (StringBuilder sb, String clazzName, boolean isCurrencyYuan, boolean isReturnThis, 
		boolean isConstruct, boolean isGetInterface, boolean isGet) {
		this.sb = sb;
		this.clazzName = clazzName;
		this.isCurrencyYuan = isCurrencyYuan;
		this.isReturnThis = isReturnThis;
		this.isConstruct = isConstruct;
		this.isGetInterface = isGetInterface;
		this.isGet = isGet;
	}
	
}
