package cn.pengh.math;

import java.util.Random;

/**
 * @author penghcn
 * @created 2015年7月16日下午3:21:47
 */
public final class JVMRandom extends Random {
	private static final long serialVersionUID = 1L;
	private boolean constructed = false;

	public JVMRandom() {
		this.constructed = true;
	}

	public synchronized void setSeed(long seed) {
		if (this.constructed)
			throw new UnsupportedOperationException();
	}

	public synchronized double nextGaussian() {
		throw new UnsupportedOperationException();
	}

	public void nextBytes(byte[] byteArray) {
		throw new UnsupportedOperationException();
	}

	public int nextInt() {
		return nextInt(2147483647);
	}

	public int nextInt(int n) {
		if (n <= 0) {
			throw new IllegalArgumentException(
					"Upper bound for nextInt must be positive");
		}

		return (int) (Math.random() * n);
	}

	public long nextLong() {
		return nextLong(9223372036854775807L);
	}

	public static long nextLong(long n) {
	    if (n <= 0L) {
	      throw new IllegalArgumentException("Upper bound for nextInt must be positive");
	    }
	
	    return (long)(Math.random() * n);
	}

	public boolean nextBoolean() {
		return (Math.random() > 0.5D);
	}

	public float nextFloat() {
		return (float) Math.random();
	}

	public double nextDouble() {
		return Math.random();
	}
}
