package cn.pengh.util;

import java.lang.reflect.Array;
import java.util.Arrays;

/**
 * org.apache.commons.lang3.ArrayUtils
 * @author penghcn
 * @created 2016年3月23日上午9:44:26
 */
public class ArrayUtil {
	//ArrayUtils.addAll(first, second);
    @SuppressWarnings("unchecked")
	public static <T> T[] concatAll(T[] first, T[]... rests) {
    	if (rests == null)
    		return first;
    	if (first == null) {
    		first = (T[]) Array.newInstance(rests[0].getClass().getComponentType(),rests.length);
    	}
    	int offset = first.length ,totalSize = offset;
		for (T[] array : rests) {
			totalSize += array.length;		
		}
    	T[] result = Arrays.copyOf(first, totalSize);
    	for (T[] array : rests) {
			System.arraycopy(array, 0, result, offset, array.length);	
			offset += array.length;
		}
    	return result;
    }
    
    public static char[] concatAll(char[] first, char[]... rests) {
    	if (rests == null)
    		return first;
    	if (first == null) {
    		first = (char[]) Array.newInstance(rests[0].getClass().getComponentType(),rests.length);
    	}
    	int offset = first.length ,totalSize = offset;
		for (char[] array : rests) {
			totalSize += array.length;		
		}
		char[] result = Arrays.copyOf(first, totalSize);
    	for (char[] array : rests) {
			System.arraycopy(array, 0, result, offset, array.length);	
			offset += array.length;
		}
    	return result;
    }
}
