package cn.pengh.crypt;

import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;

public class SHA {
	public static final int BUFFER_SIZE = 2048;
	public static final String CHARSET = "UTF-8";
	public static final String ALGORITHM_SHA_1 = "SHA-1";
	public static final String ALGORITHM_SHA_256 = "SHA-256";
	public static final String ALGORITHM_SHA_384 = "SHA-384";
	public static final String ALGORITHM_SHA_512 = "SHA-512";

	public static byte[] getDigest(InputStream in, String algorithm) throws Throwable {
		MessageDigest md = MessageDigest.getInstance(algorithm);
		try {
			DigestInputStream dis = new DigestInputStream(in, md);
			byte[] buffer = new byte[BUFFER_SIZE];
			while (dis.read(buffer) != -1) {
				dis.close();
			}
			return md.digest();
		} finally {
			in.close();
		}
	}

    public static String getDigest(String original, String algorithm){
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            byte[] origBytes = original.getBytes(CHARSET);
            md.update(origBytes);
            return getDigestString(md.digest());
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }

    }
	
	public static String getDigestString(InputStream in, String algorithm) throws Throwable {
		return getDigestString(getDigest(in, algorithm));
	}
	
	public static String getDigestString(byte[] digest) {
		StringBuilder sb = new StringBuilder();
		String tempStr = null;
		for (int i = 0; i < digest.length; i++) {
			//sb.append(String.format("%x", digest[i]));
			// 这里按位与是为了把字节转整时候取其正确的整数，java中一个int是4个字节 
			// 如果origBytes[i]最高位为1，则转为int时，int的前三个字节都被1填充了
			tempStr = Integer.toHexString(digest[i] & 0xff); 
			if (tempStr.length() == 1) 
				sb.append("0");
			sb.append(tempStr);
		}
		return sb.toString();
	}
	


	@Deprecated
	public static String shaEncrypt(String orignal) {
		return getDigest(orignal, ALGORITHM_SHA_1);
	}
	
	public static String sha256Encrypt(String orignal) {
		return getDigest(orignal, ALGORITHM_SHA_256);
	}
	
	public static String sha384Encrypt(String orignal) {
		return getDigest(orignal, ALGORITHM_SHA_384);
	}
	
	public static String sha512Encrypt(String orignal) {
		return getDigest(orignal, ALGORITHM_SHA_512);
	}
	
	/**
	 * 
	 * @param pwd 原始密码
	 * @param hash 加密后hash值
	 * @return
	 */
	@Deprecated
	public static boolean check(String pwd,String hash){
		return hash != null && hash.toLowerCase().equals(shaEncrypt(pwd).toLowerCase());
	}
	public static boolean check256(String pwd,String hash){
		return hash != null && hash.toLowerCase().equals(sha256Encrypt(pwd).toLowerCase());
	}
	public static boolean check384(String pwd,String hash){
		return hash != null && hash.toLowerCase().equals(sha384Encrypt(pwd).toLowerCase());
	}
	public static boolean check512(String pwd,String hash){
		return hash != null && hash.toLowerCase().equals(sha512Encrypt(pwd).toLowerCase());
	}
}
