package cn.pengh.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import cn.pengh.helper.ClazzHelper.MFVT;
import net.sf.cglib.beans.BeanGenerator;
import net.sf.cglib.beans.BeanMap;
/**
 * https://github.com/cglib/cglib/wiki/Tutorial
 * @author pengh
 * @Date 2016年5月11日 下午5:37:47
 */
public class CglibDynamicBeanHelper<T> {
	private Object generatedObject = null;
	private BeanMap beanMap = null;
	protected BeanGenerator generator = new BeanGenerator();
	protected List<MFVT> mvs = new ArrayList<MFVT>();
	protected T object;
	
	public CglibDynamicBeanHelper(){super();};
	public CglibDynamicBeanHelper(Map<String,Class<?>> propertyMap){
		this.generatedObject = generateBean(null,propertyMap);
		this.beanMap = BeanMap.create(this.generatedObject);
	}
	public CglibDynamicBeanHelper(T object, Map<String,Class<?>> propertyMap){
		this.object = object;
		gen(propertyMap);
	}
	public CglibDynamicBeanHelper(T object){
		this.object = object;
		gen();
	}
	
	private void gen(){
		gen(null);
	}
	private void gen(Map<String,Class<?>> propertyMap){
		this.mvs = ClazzHelper.MV(object);
		addProperties();
		this.generatedObject = generateBean(object == null ? null : object.getClass(),propertyMap);
		this.beanMap = BeanMap.create(this.generatedObject);
		addValues();
	}
	
	private Object generateBean(Class<?> superClazz,Map<String, Class<?>> propertyMap) {
		generator.setSuperclass(superClazz);
		if (propertyMap != null && propertyMap.size() > 0) {
			for (Map.Entry<String, Class<?>> e : propertyMap.entrySet()) {
				generator.addProperty(e.getKey(), e.getValue());
			}
		}		
		return generator.create();
	};
	
	protected void addValues(){
		for (MFVT mfvt : mvs) {
			setValue(mfvt.getFieldName(), mfvt.getValue());
		}
	}
	
	protected void addProperties(){
		for (MFVT mfvt : mvs) {
			generator.addProperty(mfvt.getFieldName(),mfvt.getTypeClass() );
		}
	}
	
	public void setValue(String property, Object value) {
		beanMap.put(property, value);
	}
	public Object getValue(String property) {
		return beanMap.get(property);
	}
	@SuppressWarnings({ "unchecked", "hiding" })
	public <T> T getObject() {
		return (T)this.generatedObject;
	}
}
