package cn.pengh.util;

import cn.pengh.math.JVMRandom;

import java.util.Random;

/**
 * @author penghcn
 * @created 2015年7月16日下午3:19:59
 */
public class RandomUtil {
	public static final Random JVM_RANDOM = new JVMRandom();
	private static final char[] CHAR_STR = { 'a', 'b', 'c', 'd', 'e', 'f', 'g',
		'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't',
		'u', 'v', 'w', 'x', 'y', 'z'};
	private static final char[] CHAR_STR_UP = { 'A', 'B', 'C', 'D', 'E', 'F', 'G',
			'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T',
			'U', 'V', 'W', 'X', 'Y', 'Z'};

	private static final char[] NUM_STR = { '0', '1', '2', '3', '4', '5', '6', '7','8', '9' };
	private static final char[] CHAR_NUM_STR = ArrayUtil.concatAll(CHAR_STR, NUM_STR);
	private static final char[] CHAR_NUM_STR_UP = ArrayUtil.concatAll(CHAR_STR, CHAR_STR_UP, NUM_STR);
	//生成指定长度位的字符(大小写)或者数字
	public static String genCharNumUp(int length) {
		return generator(length, CHAR_NUM_STR_UP);
	}
	//生成指定长度位的字符或者数字
	public static String genCharNum(int length) {
		return generator(length, CHAR_NUM_STR);
	}
	//生成指定长度位的字符
	public static String genChar(int length) {
		return generator(length, CHAR_STR);
	}
	//生成指定长度位的随机数
	public static String genNum(int length) {
		return generator(length, NUM_STR);
	}
	//生成指定长度位的随机str
	private static String generator(int length, char[] str) {
		if (length == 0)
			return "";
		final int maxNum = str.length;
		int i;
		int count = 0;
		StringBuffer pwd = new StringBuffer();
		while (count < length) {
			i = nextInt(maxNum);
			if (i >= 0 && i < str.length) {
				pwd.append(str[i]);
				count++;
			}
		}
		return pwd.toString();
	}
	
	
	
	
	public static int nextIntNoZero() {
		return 1+nextInt();
	}
	public static int nextIntNoZero(int n) {
		return 1+nextInt(n);
	}
	
	
	public static int nextInt() {
		return nextInt(JVM_RANDOM);
	}

	public static int nextInt(Random random) {
		return random.nextInt();
	}

	public static int nextInt(int n) {
		return nextInt(JVM_RANDOM, n);
	}
	
	

	public static int nextInt(Random random, int n) {
		return random.nextInt(n);
	}

	public static long nextLong() {
		return nextLong(JVM_RANDOM);
	}

	public static long nextLong(Random random) {
		return random.nextLong();
	}

	public static boolean nextBoolean() {
		return nextBoolean(JVM_RANDOM);
	}

	public static boolean nextBoolean(Random random) {
		return random.nextBoolean();
	}

	public static float nextFloat() {
		return nextFloat(JVM_RANDOM);
	}

	public static float nextFloat(Random random) {
		return random.nextFloat();
	}

	public static double nextDouble() {
		return nextDouble(JVM_RANDOM);
	}

	public static double nextDouble(Random random) {
		return random.nextDouble();
	}

	//32位随机字符串
	public static String getNonceStr(){
		return genCharNumUp(32);
	}
}
