package cn.pengh.crypt;
import java.security.MessageDigest;

public class Md5 {
	private final static String[] hexDigits = { "0", "1", "2", "3", "4", "5",
			"6", "7", "8", "9", "a", "b", "c", "d", "e", "f" };
	
	/**
	 * 转换字节数组为16进制字串
	 * 
	 * @param b
	 *            字节数组
	 * @return 16进制字串
	 */
	public static String byteArrayToHexString(byte[] b) {
		StringBuffer resultSb = new StringBuffer();
		for (int i = 0; i < b.length; i++) {
			resultSb.append(byteToHexString(b[i]));
		}
		return resultSb.toString();
	}

	/**
	 * J 转换byte到16进制
	 * 
	 * @param b
	 * @return
	 */
	private static String byteToHexString(byte b) {
		int n = b;
		if (n < 0) {
			n = 256 + n;
		}
		int d1 = n / 16;
		int d2 = n % 16;
		return hexDigits[d1] + hexDigits[d2];
	}

	/**
	 * J 编码
	 * 
	 * @param origin
	 * @return
	 */

	// MessageDigest 为 JDK 提供的加密类
	public static String MD5Encode(String origin) {		
		return MD5Encode(origin, "UTF-8");
	}
	
	// MessageDigest 为 JDK 提供的加密类
	public static String MD5Encode(String origin,String charsetName) {
		origin =origin.trim();
		String resultString = null;
		try {
			resultString = new String(origin);
			MessageDigest md = MessageDigest.getInstance("MD5");
			resultString = byteArrayToHexString(md.digest(resultString
					.getBytes(charsetName)));
		} catch (Exception ex) {
			ex.printStackTrace();
		}
		return resultString;
	}
	
	public static String MD5Encode(String origin, int n) {
		int len = origin.length();
		for (int i = 0; i < n; i++){
			origin = MD5Encode(origin + i % len);				
		}
		return origin;
	}
	
	public static String myMd5(String origin,String salt) {
		String forMyMd5 = "横寨";
		for (int i = 0; i < 8192; i++) {
			forMyMd5 = MD5Encode(origin + forMyMd5 + MD5Encode(salt + forMyMd5)).substring(i%32,32);
		}
		forMyMd5 = MD5Encode(origin + forMyMd5 + salt).substring(8,24).toUpperCase();		
		return forMyMd5;
	}
	
	public static boolean check(String pwd,String md5){
		return md5 != null && md5.equals(MD5Encode(pwd));
	}
}
