package cn.pengh.core.data.res;

import cn.pengh.core.constant.ResponseCodeEnum;

import java.util.List;

public class RestResBuilder {
    public static RestfulResponse build() {
        return new RestfulResponse(ResponseCodeEnum.SUCCESS.getCode(), ResponseCodeEnum.SUCCESS.getDesc());
    }

    public static RestfulResponse build(int code, String desc) {
        return new RestfulResponse(code, desc);
    }

    public static RestfulResponse build(IRestResData data) {
        return RestfulResponse.create(ResponseCodeEnum.SUCCESS.getCode(), ResponseCodeEnum.SUCCESS.getDesc()).setData(data);
    }

    public static RestfulResponse build(List<?> list) {
        return build(list, null);
    }

    public static RestfulResponse build(List<?> list, Long totalCount) {
        return build(new RestResDatas(list)).setTotalCount(totalCount).build();
    }
}
