package cn.pengh.core.context;

import org.springframework.context.ApplicationContext;

/**
 * web上下文持有类
 * @author Aillans,penghcn
 * @created 2016年1月5日上午10:34:38
 */
public class AppCtxKeeper {
	private static ApplicationContext appCtx = null;
	public static void init(ApplicationContext ctxVal) {
		appCtx = ctxVal;
	}
	public static ApplicationContext getInstance() {
		return appCtx;
	}
	//获取含类型信息的bean
	public static <T>  T loadBeanByNm(String beanName, Class<T>clazz) {
		return appCtx.getBean(beanName, clazz);
	}
	public static <T>  T getBean(Class<T> clazz) {
		return appCtx.getBean(clazz);
	}
	@SuppressWarnings("unchecked")
	@Deprecated
	public static <T> T loadBeanByNm(String beanName){
		return (T) appCtx.getBean(beanName);
	}
}
