package cn.pengh.core.constant;

/**
 * @author pengh
 * @Date 2016年11月30日 上午9:41:51
 */
@Deprecated
public enum PayModeThirdEnum {
    WX_JS_PAY((short) 0, "微信公众号支付", "微信支付", "JSAPI", "WECHAT"),
    WX_APP_PAY((short) 1, "微信APP支付", "微信支付", "APP", "WXAPP"),
    WX_WE_PAY((short) 2, "微信小程序支付", "微信支付", "LETPAY", "WECHAT"),
    QQ_PAY((short) 4, "QQ页面支付", "QQ支付", "QQ", "QQ"),
    QQ_JS_PAY((short) 5, "QQJS支付", "QQ支付", "QQJSAPI", "QQ"),
    ALI_PAY((short) 6, "支付宝生活号(原服务窗)支付", "支付宝支付", "FWC", "ALIPAY"),
    BAI_DU_WALLET_PAY((short) 8, "百度钱包支付", "百度支付", "JDJSAPI", ""),
    JD_PAY((short) 9, "京东金融支付", "京东支付", "JDJSAPI", "JD");


    private short code;
    private String desc;
    private String shortDesc;
    private String tradeType;
    private String orderType;

    private PayModeThirdEnum(short code, String desc, String shortDesc, String tradeType, String orderType) {
        this.code = code;
        this.desc = desc;
        this.shortDesc = shortDesc;
        this.tradeType = tradeType;
        this.orderType = orderType;
    }

    public short getCode() {
        return code;
    }

    public void setCode(short code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getTradeType() {
        return tradeType;
    }

    public void setTradeType(String tradeType) {
        this.tradeType = tradeType;
    }

    public String getOrderType() {
        return orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public static String getDesc(short code) {
        return get(code).getDesc();
    }

    public String getShortDesc() {
        return shortDesc;
    }

    public void setShortDesc(String shortDesc) {
        this.shortDesc = shortDesc;
    }

    public static PayModeThirdEnum get(short code) {
        for (PayModeThirdEnum e : PayModeThirdEnum.values()) {
            if (code == e.getCode())
                return e;
        }
        return null;
    }

    public static PayModeThirdEnum getByName(String name) {
        for (PayModeThirdEnum e : PayModeThirdEnum.values()) {
            if (name.equals(e.toString()))
                return e;
        }
        return null;
    }
}


