package cn.pengh.library;

import cn.pengh.util.DateUtil;
import cn.pengh.util.StringUtil;

import java.io.*;
import java.util.ArrayList;
import java.util.List;

/**
 * 根据建表语句把对应字段拼成java field
 * jsqlparser
 * @author penghcn
 * @created 2016年2月2日下午4:53:44
 */
public class JavaFieldBuilder2 {
	private StringBuilder sb = new StringBuilder();
	private boolean isTestNull = false;

	public String parseFile2(File file){
		isTestNull = true;
		return parseFile(file);
	}
	
	public String parseFile(File file){
		sb.append("/* auto generated by penghcn "+DateUtil.getCurrDay("yyyy/MM/dd HH:mm:ss.SSS")+" */");
		sb.append(System.getProperty("line.separator"));
		
		BufferedReader scan = null;
		try {
			scan = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
			String line = null,fieldType = null,field = null;
			List<String> list = null, keys = new ArrayList<String>();
			while ((line = scan.readLine()) != null) {	
				if (!(line.indexOf(",") > -1))
					continue;
				list = new ArrayList<String>();
				for (String s : line.replaceAll("(.*)(,(\\s+)?)--(.*)", "$1").split(" ")) {
					if (!s.equals(""))
						list.add(s.trim().toLowerCase());
				}
				if (list.size() == 0)
					continue;
								
				//Log.debug(list);
				field = list.get(0);
				keys.add(field);
				
				if ("primary".equals(field) || "unique".equals(field))
					continue;
			}
			scan.close();

			StringBuilder sbVal = new StringBuilder();
			sbVal.append(System.getProperty("line.separator"))
					.append("values (")
					.append(System.getProperty("line.separator")).append("\t");

			sb.append("insert into <include refid=\"tbl\"/> (").append(System.getProperty("line.separator")).append("\t");
			int count = 0;
			for (String key : keys) {

				if ("primary".equals(key))
					continue;

				if (isTestNull) {
					sb.append("<if test=\"").append(StringUtil.toCamelCase(key)).append(" != null \">").append(System.getProperty("line.separator"));
					sbVal.append("<if test=\"").append(StringUtil.toCamelCase(key)).append(" != null \">").append(System.getProperty("line.separator"));
				}

				sb.append(key).append(", ");


				if ("row_id".equals(key) || "id".equals(key)) {
					sbVal.append("default, ");
				} else if ("crt_ts".equals(key) || "upd_ts".equals(key)) {
					sbVal.append("current_timestamp(6), ");
				} else {
					sbVal.append("#{").append(StringUtil.toCamelCase(key)).append("}").append(", ");
				}



				if (isTestNull) {
					sb.append(System.getProperty("line.separator")).append("</if>").append(System.getProperty("line.separator"));
					sbVal.append(System.getProperty("line.separator")).append("</if>").append(System.getProperty("line.separator"));
				}
				count++;
				if (count %8 == 0) {
					sb.append(System.getProperty("line.separator")).append("\t");
					sbVal.append(System.getProperty("line.separator")).append("\t");
				}
			}
			sb.append(")");
			sbVal.append(");");
			return sb.toString().replaceAll("(.*), \\)","$1)")+sbVal.toString().replaceAll("(.*), \\)","$1)");
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		} finally {
			try {
				if(scan != null)
					scan.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}
	
}
