package cn.pengh.library;

import cn.pengh.util.DateUtil;
import cn.pengh.util.StringUtil;

import java.io.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 根据建表语句把对应字段拼成java field
 * jsqlparser
 * @author penghcn
 * @created 2016年2月2日下午4:53:44
 */
public class JavaFieldBuilder {
	private StringBuilder sb = new StringBuilder();
	private boolean isHibernateJpa = false;

	
	public String parseFile(File file){
		sb.append("/* auto generated by penghcn "+DateUtil.getCurrDay("yyyy/MM/dd HH:mm:ss.SSS")+" */");
		sb.append(System.getProperty("line.separator"));
		
		BufferedReader scan = null;
		try {
			scan = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
			String line = null,fieldType = null,field = null;
			List<String> list = null;
			while ((line = scan.readLine()) != null) {	
				if (!(line.indexOf(",") > -1))
					continue;
				list = new ArrayList<String>();
				for (String s : line.replaceAll("(.*)(,(\\s+)?)--(.*)", "$1").split(" ")) {
					if (!s.equals(""))
						list.add(s.trim().toLowerCase());
				}
				if (list.size() == 0)
					continue;
								
				//Log.debug(list);
				fieldType = getFieldType(list.get(1));
				field = list.get(0);
				
				if ("primary".equals(field) || "unique".equals(field))
					continue;
				
				if (isHibernateJpa) {
					sb.append(System.getProperty("line.separator"));
					
					if ("row_id".equals(field) || "id".equals(field)) {
						sb.append("@Id").append(System.getProperty("line.separator"));
						sb.append("@GeneratedValue(strategy = GenerationType.IDENTITY)")
							.append(System.getProperty("line.separator"));
					}
					if ("String".equals(fieldType)) {
						sb.append("@Type(type=\"trimStringUserType\")");
						sb.append(System.getProperty("line.separator"));
						sb.append("@Column(name=\""+field)
							.append("\",length="+(list.get(1).replaceAll("^(.*)\\((\\d+)\\)$", "$2")))
							.append(")");
					} else {
						sb.append("@Column(name=\""+field+"\")");
					}
					sb.append(System.getProperty("line.separator"));
				}
				sb.append("private ");
				sb.append(fieldType);
				sb.append(" ");
				sb.append(StringUtil.toCamelCase(field));
				sb.append(";");
				sb.append(System.getProperty("line.separator"));
			}
			scan.close();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if(scan != null)
					scan.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return sb.toString();
	}
	private String getFieldType(String str){
		//DECIMAL(2,0)
		str = str.toUpperCase();
		if (str.startsWith("DECIMAL")) {
			int scale1, scale2;
			if (str.indexOf(",") > -1) {
				scale1 = Integer.valueOf(str.replaceAll("DECIMAL\\((\\d+),(\\d+)\\)$", "$1"));
				scale2 = Integer.valueOf(str.replaceAll("DECIMAL\\((\\d+),(\\d+)\\)$", "$2"));
			} else {
				scale1 = Integer.valueOf(str.replaceAll("DECIMAL\\((\\d+)\\)$", "$1"));
				scale2 = 0;				
			}
			
			if (scale2 != 0) {
				return "BigDecimal";
			} else if (scale1 < 3) {//Byte.MAX_VALUE = 127
				return "Byte";
			}  else if (scale1 < 5) {//Short.MAX_VALUE = 32767
				return "Short";
			} else if (scale1 < 10) {//Integer.MAX_VALUE = 2147483647
				return "Integer";
			} else {
				return "Long";
			}
		}
		return fieldTypeMap.get(str.replaceAll("(.*)\\((.*)(,)?", "$1"));
	}
	
	private static Map<String,String> fieldTypeMap = new HashMap<String, String>(){
		private static final long serialVersionUID = 7243153239082052374L;{
			put("INTEGER","Integer");
			put("INT","Integer");
			put("SMALLINT","Short");
			put("TINYINT","Short");
			put("BIGINT","Long");
			put("TIMESTAMP","String");
			put("DATETIME","String");
			put("CHAR","String");
			put("VARCHAR","String");
			put("CLOB","String");
		}
	};
	
}
