package cn.pengh.helper;

import cn.pengh.crypt.Md5;
import cn.pengh.crypt.RSA;
import cn.pengh.crypt.SHA;
import cn.pengh.library.Log;
import cn.pengh.util.TemplateUtil;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Created by pengh
 * @datetime 2018/10/11 10:46
 */
public class SignHelper {
    public static final String CHARSET = "utf-8";
    public static final String SIGN_MD5 = "MD5";
    @Deprecated
    public static final String SIGN_SHA = "SHA";
    @Deprecated
    public static final String SIGN_SHA128 = "SHA128";
    public static final String SIGN_SHA256 = "SHA256";
    public static final String SIGN_SHA384 = "SHA384";
    public static final String SIGN_SHA512 = "SHA512";
    public static final String SIGN_RSA = "RSA";
    public static final String SIGN_HMAC_SHA256 = "HMAC-SHA256";
    private static final String HMAC_SHA256 = "HmacSHA256";


    public static String sign(String signType, String appKey, Object obj){
        return sign(signType, appKey, obj, null);
    }
    public static String sign(String signType, String appKey, Object obj, List<String> excepts){
        return sign(signType, appKey, obj, excepts, null);
    }
    /**
     * 默认md5加密
     * @param signType
     * @param appKey
     * @param obj
     * @param excepts
     * @param replaceMap
     * @return
     */
    public static String sign(String signType, String appKey, Object obj, List<String> excepts, Map<String,String> replaceMap){
        String str = ClazzHelper.getSortedFieldsVal(obj, excepts, replaceMap, true);
        Log.trace(str);
        String strWithKey = str+"&key="+appKey;

        switch (signType.toUpperCase()) {
            case SIGN_MD5:
                return Md5.MD5Encode(strWithKey).toUpperCase();
            case SIGN_SHA256:
                return SHA.sha256Encrypt(strWithKey).toUpperCase();
            case SIGN_SHA512:
                return SHA.sha512Encrypt(strWithKey).toUpperCase();
            case SIGN_SHA384:
                return SHA.sha384Encrypt(strWithKey).toUpperCase();
            case SIGN_HMAC_SHA256:
                return doHMacSHA256(strWithKey, appKey).toUpperCase();
            case SIGN_RSA:
                return RSA.sign(str, appKey);
            case SIGN_SHA:
                return SHA.shaEncrypt(strWithKey).toUpperCase();
            case SIGN_SHA128:
                return SHA.shaEncrypt(strWithKey).toUpperCase();
            default:
                return Md5.MD5Encode(strWithKey).toUpperCase();
        }
    }
    private static String byteArrayToHexString(byte[] b) {
        StringBuilder hs = new StringBuilder();
        String stmp;
        for (int n = 0; b!=null && n < b.length; n++) {
            stmp = Integer.toHexString(b[n] & 0XFF);
            if (stmp.length() == 1)
                hs.append('0');
            hs.append(stmp);
        }
        return hs.toString().toLowerCase();
    }
    /**
     * sha256_HMAC加密
     * @param message 消息
     * @param secret  秘钥
     * @return 加密后字符串
     */
    public static String doHMacSHA256(String message, String secret) {
        try {
            Mac hMacSha256 = Mac.getInstance(HMAC_SHA256);
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(CHARSET), HMAC_SHA256);
            hMacSha256.init(secretKey);
            //byte[] bytes = hMacSha256.doFinal(message.getBytes(CHARSET));
            //hash = Base64.encodeBase64String(bytes);
            return byteArrayToHexString(hMacSha256.doFinal(message.getBytes(CHARSET)));
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }

    }

    public static String signSha256(String appKey, Object obj){
        return signSha256(appKey, obj, "");
    }


    public static String signSha256(String appKey, Object obj, String excepts){
        return signSha256(appKey, obj, excepts == null ? null : Arrays.asList(excepts.split(",")));
    }

    public static String signSha256(String appKey, Object obj, List<String> excepts){
        return signSha256(appKey, obj, excepts, null);
    }

    public static String signSha256(String appKey, Object obj, List<String> excepts, Map<String,String> replaceMap) {
        return sign(SIGN_SHA256, appKey, obj, excepts, replaceMap);
    }



    public static String signMd5(String appKey, Object obj){
        return signMd5(appKey, obj, "");
    }


    public static String signMd5(String appKey, Object obj, String excepts){
        return signMd5(appKey, obj, excepts == null ? null : Arrays.asList(excepts.split(",")));
    }

    public static String signMd5(String appKey, Object obj, List<String> excepts){
        return signMd5(appKey, obj, excepts, null);
    }

    /**
     *
     * @param appKey
     * @param obj
     * @param excepts 不需要加入签名的属性字段
     * @param replaceMap 有些属性字段需要替换，使用别名
     * @return
     */
    public static String signMd5(String appKey, Object obj, List<String> excepts, Map<String,String> replaceMap) {
        return sign(SIGN_MD5, appKey, obj, excepts, replaceMap);
    }


    /**
     *
     * @param template
     * @param appKey
     * @param obj
     * @return
     */
    public static String signMd5(String template, String appKey, Object obj) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (ClazzHelper.MFVT mfvt : ClazzHelper.MV(obj)) {
            if (mfvt.getValue() == null)
                continue;
            map.put(mfvt.getFieldName(), mfvt.getValue());
        }//Log.debug(TemplateUtil.renderStr(template, map));
        return Md5.MD5Encode(TemplateUtil.renderStr(template, map)+"&key="+appKey).toUpperCase();
    }

    public static void main(String[] args) {

    }

}
