package cn.payingcloud.umf.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.ArrayList;
import java.util.List;

/**
 * 子订单实体类
 */
public class SubOrder {

    @JsonProperty("mer_sub_reference_id")
    private String merSubReferenceId;    //商户子订单号

    @JsonProperty("trans_code")
    private String transCode;        //子订单业务编码

    @JsonProperty("sub_trans_type")
    private String subTransType;        //子订单业务类型

    private Amount amount;            //子订单金额

    @JsonProperty("is_customs")
    private String isCustoms;            //是否报关

    @JsonProperty("invoice_id")
    private String invoiceId;            //子单发票号

    private List<Item> items;            //交易明细，具体见item对象的说明

    SubOrder() {

    }


    public SubOrder(String merSubReferenceId, TransCode transCode, boolean isCustoms, Amount amount) {
        this.merSubReferenceId = merSubReferenceId;
        this.transCode = transCode.getCode();
        this.isCustoms = isCustoms ? "TRUE" : "FALSE";
        this.amount = amount;
        this.items = new ArrayList<>();
    }

    public SubOrder addItem(Item item) {
        items.add(item);
        return this;
    }

    public String getMerSubReferenceId() {
        return merSubReferenceId;
    }

    public void setMerSubReferenceId(String merSubReferenceId) {
        this.merSubReferenceId = merSubReferenceId;
    }

    public String getTransCode() {
        return transCode;
    }

    public void setTransCode(String transCode) {
        this.transCode = transCode;
    }

    public String getSubTransType() {
        return subTransType;
    }

    public void setSubTransType(String subTransType) {
        this.subTransType = subTransType;
    }

    public Amount getAmount() {
        return amount;
    }
//    public Amount getAmount() {
////        if (amount != null) {
////            return amount;
////        }
////        if (items.size() < 1) {
////            throw new UmfException("Items must not be empty");
////        }
////        Amount total = items.get(0).getAmount();
////        for (Item item : items) {
////            total.add(item.getAmount());
////        }
////        return total;
//    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public String getIsCustoms() {
        return isCustoms;
    }

    public void setIsCustoms(String isCustoms) {
        this.isCustoms = isCustoms;
    }

    public List<Item> getItems() {
        return items;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public String getInvoiceId() {
        return invoiceId;
    }

    public void setInvoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
    }

}

