package cn.payingcloud.umf.model;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * 风控信息实体类
 */
public class RiskInfo {
    @JsonProperty("trans_type")
    private String transType;                //B0002  交易类型  		01充值、02消费	Y

    @JsonProperty("receiver_name")
    private String receiverName;

    @JsonProperty("receiver_moblie_id")
    private String receiverMobileId;                //B0004	收货人手机号		String(11位)	接收收货信息的人的联系方式，当D0008为1或3时，该字段必填，例如： 13800011111	C

    @JsonProperty("shipping_address")
    private String shoppingAddress;                //B0005	送货地址		String	收货地址，当D0008为1或3时，该字段必填	C

    @JsonProperty("registration_email")
    private String registrationEmail;                //B0006	注册email		String	用户注册email，必须是商户已验证过的	N

    @JsonProperty("registration_moblie_id")
    private String registrationMobileId;                //B0007	注册手机号		String(11位)	注册人手机号码	N

    @JsonProperty("identify_card_number")
    private String identifyCardNumber;                //B0008	身份证号		String	注册人身份证号，当D0009为1时，该字段必填	C

    @JsonProperty("device_identification")
    private String deviceIdentification;                //D0001	设备标识		String	商户侧生成的设备唯一标识，如手机MAC码，或是内部定义的终端识别ID。	N

    @JsonProperty("device_type")
    private String deviceType;                //D0002	设备类型		String	客户端形态产品填写手机型号；页面形态产品填写浏览器User-Agent信息，如是Web端用户则不可为空。APP可为空。	N

    @JsonProperty("user_ip")
    private String userIp;                //D0003	用户ID		String	商户侧用户标识，可以是数据库主键标识，也可以是用户登陆id	N

    @JsonProperty("registration_time")
    private String registrationTime;                //D0004	用户注册时间		String	用户注册该产品的时间，精确到秒。例如： 20150311120000	N

    @JsonProperty("user_agent")
    private String userAgent;                //D0005	产品形态		String	1-android客户端；2-IOS客户端；3-PC端（web页面）；4-手机端（wap或html5等页面）；	N

    @JsonProperty("success_transactions_number")
    private String successTransactionsNumber;                //D0007用户成功交易笔数	String	用户在商户端成功交易的笔数	N

    @JsonProperty("goods_type")
    private String goodsType;                //D0008	商品分类		String	0：虚拟类/  1：实物类/ 2：机票类/ 3：3C类	Y

    @JsonProperty("real_name")
    private String realName;                //D0009	商品实名制购买	String	0：非实名制，1：实名制	Y

    @JsonProperty("business_type")
    private String businessType;                //D0010	业务分类		String	3：跨境收银	Y

    @JsonProperty("risk_expand")
    private String riskExpand;        //风控扩展信息

    RiskInfo() {
    }

    public RiskInfo(String receiverName, String receiverMobileId, String shoppingAddress, GoodsType goodsType, boolean realName) {
        this.receiverName = receiverName;
        this.receiverMobileId = receiverMobileId;
        this.shoppingAddress = shoppingAddress;
        this.goodsType = goodsType.getNumber();
        this.realName = realName ? "1" : "0";
    }

    public String getTransType() {
        return transType;
    }

    public void setTransType(String transType) {
        this.transType = transType;
    }

    public String getReceiverName() {
        return receiverName;
    }

    public void setReceiverName(String receiverName) {
        this.receiverName = receiverName;
    }

    public String getReceiverMobileId() {
        return receiverMobileId;
    }

    public void setReceiverMobileId(String receiverMobileId) {
        this.receiverMobileId = receiverMobileId;
    }

    public String getShoppingAddress() {
        return shoppingAddress;
    }

    public void setShoppingAddress(String shoppingAddress) {
        this.shoppingAddress = shoppingAddress;
    }

    public String getRegistrationEmail() {
        return registrationEmail;
    }

    public void setRegistrationEmail(String registrationEmail) {
        this.registrationEmail = registrationEmail;
    }

    public String getRegistrationMobileId() {
        return registrationMobileId;
    }

    public void setRegistrationMobileId(String registrationMobileId) {
        this.registrationMobileId = registrationMobileId;
    }

    public String getIdentifyCardNumber() {
        return identifyCardNumber;
    }

    public void setIdentifyCardNumber(String identifyCardNumber) {
        this.identifyCardNumber = identifyCardNumber;
    }

    public String getDeviceIdentification() {
        return deviceIdentification;
    }

    public void setDeviceIdentification(String deviceIdentification) {
        this.deviceIdentification = deviceIdentification;
    }

    public String getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getUserIp() {
        return userIp;
    }

    public void setUserIp(String userIp) {
        this.userIp = userIp;
    }

    public String getRegistrationTime() {
        return registrationTime;
    }

    public void setRegistrationTime(String registrationTime) {
        this.registrationTime = registrationTime;
    }

    public String getUserAgent() {
        return userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getSuccessTransactionsNumber() {
        return successTransactionsNumber;
    }

    public void setSuccessTransactionsNumber(String successTransactionsNumber) {
        this.successTransactionsNumber = successTransactionsNumber;
    }

    public String getGoodsType() {
        return goodsType;
    }

    public void setGoodsType(String goodsType) {
        this.goodsType = goodsType;
    }

    public String getRealName() {
        return realName;
    }

    public void setRealName(String realName) {
        this.realName = realName;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getRiskExpand() {
        return riskExpand;
    }

    public void setRiskExpand(String riskExpand) {
        this.riskExpand = riskExpand;
    }

}
