package cn.payingcloud.umf.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Arrays;
import java.util.List;

/**
 * @author YQ.Huang
 */
public class RefundInfo {
    @JsonProperty("mer_reference_id")
    private String merReferenceId;

    @JsonProperty("mer_date")
    private String merDate;

    private Amount amount;

    @JsonProperty("refund_summary")
    private String refundSummary;

    @JsonProperty("sub_orders")
    private List<SubOrder> subOrders;

    RefundInfo() {
    }

    public RefundInfo(String merReferenceId, Amount amount, SubOrder... subOrders) {
        this.merReferenceId = merReferenceId;
        this.amount = amount;
        this.subOrders = Arrays.asList(subOrders);
    }

    public String getMerReferenceId() {
        return merReferenceId;
    }

    public void setMerReferenceId(String merReferenceId) {
        this.merReferenceId = merReferenceId;
    }

    public String getMerDate() {
        return merDate;
    }

    public void setMerDate(String merDate) {
        this.merDate = merDate;
    }

    public Amount getAmount() {
        return amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public String getRefundSummary() {
        return refundSummary;
    }

    public void setRefundSummary(String refundSummary) {
        this.refundSummary = refundSummary;
    }

    public List<SubOrder> getSubOrders() {
        return subOrders;
    }

    public void setSubOrders(List<SubOrder> subOrders) {
        this.subOrders = subOrders;
    }
}
