package cn.payingcloud.umf.model;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * 退费信息实体类
 */
public class Refund {
    private String id;

    @JsonProperty("refund_info")
    private RefundInfo refundInfo;            //退费订单信息

    private RefundState state;            //退费状态

    @JsonProperty("notify_url")
    private String notifyUrl;        //退费通知地址

    Refund() {
    }

    public Refund(RefundInfo refundInfo, String notifyUrl) {
        this.refundInfo = refundInfo;
        this.notifyUrl = notifyUrl;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public RefundInfo getRefundInfo() {
        return refundInfo;
    }

    public void setRefundInfo(RefundInfo refundInfo) {
        this.refundInfo = refundInfo;
    }

    public RefundState getState() {
        return state;
    }

    public void setState(RefundState state) {
        this.state = state;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }
}
