package cn.payingcloud.umf.model;

import cn.payingcloud.umf.util.CipherUtils;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.security.cert.X509Certificate;

/**
 * 付款人详细信息实体类
 */
public class PayerInfo {
    @JsonProperty("bank_card")
    private BankCard bankCard;        //银行卡支付信息实体类
    @JsonProperty("qr_code_scan")
    private QrCodeScan qrCodeScan;    //主扫实体类
    @JsonProperty("payer_agreement")
    private PayerAgreement payerAgreement;//协议支付信息实体类
    @JsonProperty("phone")
    private String phone;//协议支付信息实体类
    @JsonProperty("name")
    private String name;//协议支付信息实体类
    @JsonProperty("wechat_in_app")
    private WechatInApp wechatInApp;//APP支付
    @JsonProperty("wechat_in_app_web")
    private WechatInAppWeb wechatInAppWeb;//公众号支付

    public WechatInApp getWechatInApp() {
        return wechatInApp;
    }

    public void setWechatInApp(WechatInApp wechatInApp) {
        this.wechatInApp = wechatInApp;
    }

    public WechatInAppWeb getWechatInAppWeb() {
        return wechatInAppWeb;
    }

    public void setWechatInAppWeb(WechatInAppWeb wechatInAppWeb) {
        this.wechatInAppWeb = wechatInAppWeb;
    }

    public BankCard getBankCard() {
        return bankCard;
    }

    public void setBankCard(BankCard bankCard) {
        this.bankCard = bankCard;
    }

    public QrCodeScan getQrCodeScan() {
        return qrCodeScan;
    }

    public void setQrCodeScan(QrCodeScan qrCodeScan) {
        this.qrCodeScan = qrCodeScan;
    }

    public PayerAgreement getPayerAgreement() {
        return payerAgreement;
    }

    public void setPayerAgreement(PayerAgreement payerAgreement) {
        this.payerAgreement = payerAgreement;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void encrypt(X509Certificate certificate) {
        name = CipherUtils.encrypt(name, certificate);
        if (bankCard != null) {
            bankCard.encrypt(certificate);
        }
        if (qrCodeScan != null) {
            qrCodeScan.encrypt(certificate);
        }
        if (wechatInApp != null) {
            wechatInApp.encrypt(certificate);
        }
        if (wechatInAppWeb != null) {
            wechatInAppWeb.encrypt(certificate);
        }
    }
}
