package cn.payingcloud.umf.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.security.cert.X509Certificate;

/**
 * 付款信息实体类
 */
public class Payer {
    @JsonProperty("payment_method")
    private PaymentMethod paymentMethod;//支付方式

    @JsonProperty("interface_type")
    private InterfaceType interfaceType;

    @JsonProperty("business_type")
    private BusinessType businessType;

    @JsonProperty("bank_code")
    private String bankCode;            //银行编码

    @JsonProperty("payer_info")
    private PayerInfo payerInfo;        //付款人详细信息

    public PaymentMethod getPaymentMethod() {
        return paymentMethod;
    }

    public void setPaymentMethod(PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public String getBankCode() {
        return bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public PayerInfo getPayerInfo() {
        return payerInfo;
    }

    public void setPayerInfo(PayerInfo payerInfo) {
        this.payerInfo = payerInfo;
    }

    public InterfaceType getInterfaceType() {
        return interfaceType;
    }

    public void setInterfaceType(InterfaceType interfaceType) {
        this.interfaceType = interfaceType;
    }

    public BusinessType getBusinessType() {
        return businessType;
    }

    public void setBusinessType(BusinessType businessType) {
        this.businessType = businessType;
    }

    public void encrypt(X509Certificate certificate) {
        if (payerInfo != null) {
            payerInfo.encrypt(certificate);
        }
    }
}
