package cn.payingcloud.umf.model;

/**
 * 企业资质业务类型
 */
public enum EnterpriseStatusFlag {

    ENABLE(1), // 启用
    DISABLE(0); // 不启用
    private int index;

    private EnterpriseStatusFlag(int index) {
        this.index = index;
    }

    public int getIndex() {
        return index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public static EnterpriseStatusFlag getEnterpriseStatusFlag(int valueInt) {
        EnterpriseStatusFlag enterpriseStatusFlag = null;
        switch (valueInt) {
            case 0: {
                enterpriseStatusFlag = DISABLE;
                break;
            }
            case 1: {
                enterpriseStatusFlag = ENABLE;
                break;
            }
            default: {
                enterpriseStatusFlag = DISABLE;
            }
        }
        return enterpriseStatusFlag;
    }
}
