package cn.payingcloud.umf.model;

public enum EnterpriseRank {

    A(1),//： 表示该企业是A类企业              	可做货物、服务类交易
    OTHERS(3),//： 表示该企业还未确认     	可做服务类交易
    UNKNOWN(2);//: 表示该企业是非A类企业 	不可做交易

    private int index;

    private EnterpriseRank(int index) {
        this.index = index;
    }

    public int getIndex() {
        return index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public static EnterpriseRank getEnterpriseStatusFlag(int valueInt) {
        EnterpriseRank enterpriseStatusFlag = null;
        switch (valueInt) {

            case 1: {
                enterpriseStatusFlag = A;
                break;
            }
            case 3: {
                enterpriseStatusFlag = OTHERS;
                break;
            }
            default: {
                enterpriseStatusFlag = UNKNOWN;
            }
        }
        return enterpriseStatusFlag;
    }
}
