package cn.payingcloud.umf.model;


import cn.payingcloud.umf.util.CipherUtils;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.security.cert.X509Certificate;

/**
 * 银行卡支付信息实体类
 */
public class BankCard {
    private String number;                //银行卡号(RSA)

    @JsonProperty("citizen_id_number")
    private String citizenIdNumber;        //证件号码(RSA)

    @JsonProperty("citizen_id_type")
    private CitizenIdType citizenIdType;        //证件类型

    @JsonProperty("payer_name")
    private String payerName;            //持卡人姓名(RSA)

    @JsonProperty("valid_date")
    private String validDate;            //有效期(YYMM)

    private String cvv2;                //CVV2(RSA)

    private String phone;                //付款人电话

    @JsonProperty("external_customer_id")
    private String externalCustomerId;    //商户用户标识

    private String state;                //状态，expired,ok，unavailable（例如挂失）

    @JsonProperty("verify_code")
    private String verifyCode;            //短信验证码

    BankCard() {
    }

    public BankCard(String number, String citizenIdNumber, CitizenIdType citizenIdType, String payerName, String phone) {
        this.number = number;
        this.citizenIdNumber = citizenIdNumber;
        this.citizenIdType = citizenIdType;
        this.payerName = payerName;
        this.phone = phone;
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getCitizenIdNumber() {
        return citizenIdNumber;
    }

    public void setCitizenIdNumber(String citizenIdNumber) {
        this.citizenIdNumber = citizenIdNumber;
    }

    public CitizenIdType getCitizenIdType() {
        return citizenIdType;
    }

    public void setCitizenIdType(CitizenIdType citizenIdType) {
        this.citizenIdType = citizenIdType;
    }

    public String getPayerName() {
        return payerName;
    }

    public void setPayerName(String payerName) {
        this.payerName = payerName;
    }

    public String getValidDate() {
        return validDate;
    }

    public void setValidDate(String validDate) {
        this.validDate = validDate;
    }

    public String getCvv2() {
        return cvv2;
    }

    public void setCvv2(String cvv2) {
        this.cvv2 = cvv2;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getExternalCustomerId() {
        return externalCustomerId;
    }

    public void setExternalCustomerId(String externalCustomerId) {
        this.externalCustomerId = externalCustomerId;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getVerifyCode() {
        return verifyCode;
    }

    public void setVerifyCode(String verifyCode) {
        this.verifyCode = verifyCode;
    }

    public void encrypt(X509Certificate certificate) {
        number = CipherUtils.encrypt(number, certificate);
        citizenIdNumber = CipherUtils.encrypt(citizenIdNumber, certificate);
        payerName = CipherUtils.encrypt(payerName, certificate);
        cvv2 = CipherUtils.encrypt(cvv2, certificate);
        validDate = CipherUtils.encrypt(validDate, certificate);
    }
}
