package cn.payingcloud.umf.model;


import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;


/**
 * 银行列表实体
 */
public class Bank {
    private String name; // 银行英文全称

    @JsonProperty("name_zh")
    private String nameZh; // 银行中文全称

    private String code; // 银行简称

    @JsonProperty("logo_url")
    private String logoUrl; // 银行图标样式

    private List<BankCardType> types; // 类型(CREDIT_CARD信用卡, DEBIT_CARD借记卡)

    @JsonProperty("is_support")
    private String isSupport; // 联动是否支持

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameZh() {
        return nameZh;
    }

    public void setNameZh(String nameZh) {
        this.nameZh = nameZh;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getLogoUrl() {
        return logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public List<BankCardType> getTypes() {
        return types;
    }

    public void setTypes(List<BankCardType> types) {
        this.types = types;
    }

    public String getIsSupport() {
        return isSupport;
    }

    public void setIsSupport(String isSupport) {
        this.isSupport = isSupport;
    }

}
