package cn.payingcloud.umf;

import cn.payingcloud.umf.model.*;

public class PaymentBuilder {

    private final Payer payer;                //付款信息
    private final Order order;                //订单信息
    private final String notifyUrl;            //结果后台通知
    private String retUrl;                //结果前台通知
    private final RiskInfo riskInfo;            //风控对象

    public static PaymentBuilder ofWxScanCode(String name, String phone, String citizenIdNumber, Order order, String notifyUrl, RiskInfo riskInfo) {
        QrCodeScan qrCodeScan = new QrCodeScan(citizenIdNumber);
        PayerInfoBuilder payerInfoBuilder = PayerInfoBuilder.ofCodeScan(phone, qrCodeScan);
        payerInfoBuilder.setName(name);
        PayerBuilder payerBuilder = PayerBuilder.ofWxScanCode(payerInfoBuilder.build());
        return new PaymentBuilder(payerBuilder.build(), order, notifyUrl, riskInfo);
    }

    public static PaymentBuilder ofAliScanCode(String name, String phone, String citizenIdNumber, Order order, String notifyUrl, RiskInfo riskInfo) {
        QrCodeScan qrCodeScan = new QrCodeScan(citizenIdNumber);
        PayerInfoBuilder payerInfoBuilder = PayerInfoBuilder.ofCodeScan(phone, qrCodeScan);
        payerInfoBuilder.setName(name);
        PayerBuilder payerBuilder = PayerBuilder.ofAliScanCode(payerInfoBuilder.build());
        return new PaymentBuilder(payerBuilder.build(), order, notifyUrl, riskInfo);
    }

    public static PaymentBuilder ofBank(String phone, BankCard bankCard, BankCode bankCode, Order order, String notifyUrl, RiskInfo riskInfo) {
        PayerInfoBuilder payerInfoBuilder = PayerInfoBuilder.ofBankCard(phone, bankCard);
        PayerBuilder payerBuilder;
        if (bankCard.getCvv2() != null || bankCard.getValidDate() != null)
            payerBuilder = PayerBuilder.ofBankCredit(payerInfoBuilder.build(), bankCode);
        else
            payerBuilder = PayerBuilder.ofBankDebit(payerInfoBuilder.build(), bankCode);
        return new PaymentBuilder(payerBuilder.build(), order, notifyUrl, riskInfo);
    }

    public static PaymentBuilder ofWxWeb(String name, String phone, String citizenIdNumber, Order order, String notifyUrl, RiskInfo riskInfo) {
        WechatInAppWeb wechatInAppWeb = new WechatInAppWeb(citizenIdNumber);
        PayerInfoBuilder payerInfoBuilder = PayerInfoBuilder.ofWxWeb(phone, wechatInAppWeb);
        payerInfoBuilder.setName(name);
        PayerBuilder payerBuilder = PayerBuilder.ofWxWeb(payerInfoBuilder.build());
        return new PaymentBuilder(payerBuilder.build(), order, notifyUrl, riskInfo);
    }

    public static PaymentBuilder ofWxApp(String name, String phone, String citizenIdNumber, Order order, String notifyUrl, RiskInfo riskInfo) {
        WechatInApp wechatInApp = new WechatInApp();
        PayerInfoBuilder payerInfoBuilder = PayerInfoBuilder.ofWxApp(phone, wechatInApp);
        payerInfoBuilder.setName(name);
        PayerBuilder payerBuilder = PayerBuilder.ofWxApp(payerInfoBuilder.build());
        return new PaymentBuilder(payerBuilder.build(), order, notifyUrl, riskInfo);
    }

    private PaymentBuilder(Payer payer, Order order, String notifyUrl, RiskInfo riskInfo) {
        this.payer = payer;
        this.order = order;
        this.notifyUrl = notifyUrl;
        this.riskInfo = riskInfo;
    }

    public Payer getPayer() {
        return payer;
    }

    public Order getOrder() {
        return order;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public String getRetUrl() {
        return retUrl;
    }

    public void setRetUrl(String retUrl) {
        this.retUrl = retUrl;
    }

    public RiskInfo getRiskInfo() {
        return riskInfo;
    }

    public Payment build() {
        Payment payment = new Payment();
        payment.setPayer(payer);
        payment.setOrder(order);
        payment.setNotifyUrl(notifyUrl);
        payment.setRetUrl(retUrl);
        payment.setRiskInfo(riskInfo);
        return payment;
    }
}
