package cn.payingcloud.umf;

import cn.payingcloud.umf.model.*;

public class PayerInfoBuilder {
    private BankCard bankCard;        //银行卡支付信息实体类
    private QrCodeScan qrCodeScan;    //主扫实体类
    private PayerAgreement payerAgreement;//协议支付信息实体类
    private final String phone;
    private String name;
    private WechatInApp wechatInApp;//APP支付
    private WechatInAppWeb wechatInAppWeb;//公众号支付

    public static PayerInfoBuilder ofBankCard(String phone, BankCard bankCard) {
        PayerInfoBuilder builder = new PayerInfoBuilder(phone);
        builder.setBankCard(bankCard);
        return builder;
    }

    public static PayerInfoBuilder ofCodeScan(String phone, QrCodeScan codeScan) {
        PayerInfoBuilder builder = new PayerInfoBuilder(phone);
        builder.setQrCodeScan(codeScan);
        return builder;
    }

    public static PayerInfoBuilder ofWxWeb(String phone, WechatInAppWeb wechatInAppWeb) {
        PayerInfoBuilder builder = new PayerInfoBuilder(phone);
        builder.setWechatInAppWeb(wechatInAppWeb);
        return builder;
    }

    public static PayerInfoBuilder ofWxApp(String phone, WechatInApp wechatInApp) {
        PayerInfoBuilder builder = new PayerInfoBuilder(phone);
        builder.setWechatInApp(wechatInApp);
        return builder;
    }

    private PayerInfoBuilder(String phone) {
        this.phone = phone;
    }

    public BankCard getBankCard() {
        return bankCard;
    }

    public void setBankCard(BankCard bankCard) {
        this.bankCard = bankCard;
    }

    public QrCodeScan getQrCodeScan() {
        return qrCodeScan;
    }

    public void setQrCodeScan(QrCodeScan qrCodeScan) {
        this.qrCodeScan = qrCodeScan;
    }

    public PayerAgreement getPayerAgreement() {
        return payerAgreement;
    }

    public void setPayerAgreement(PayerAgreement payerAgreement) {
        this.payerAgreement = payerAgreement;
    }

    public String getPhone() {
        return phone;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WechatInApp getWechatInApp() {
        return wechatInApp;
    }

    public void setWechatInApp(WechatInApp wechatInApp) {
        this.wechatInApp = wechatInApp;
    }

    public WechatInAppWeb getWechatInAppWeb() {
        return wechatInAppWeb;
    }

    public void setWechatInAppWeb(WechatInAppWeb wechatInAppWeb) {
        this.wechatInAppWeb = wechatInAppWeb;
    }

    public PayerInfo build() {
        PayerInfo payerInfo = new PayerInfo();
        payerInfo.setPhone(phone);
        payerInfo.setName(name);
        payerInfo.setBankCard(bankCard);
        payerInfo.setQrCodeScan(qrCodeScan);
        payerInfo.setPayerAgreement(payerAgreement);
        payerInfo.setWechatInApp(wechatInApp);
        payerInfo.setWechatInAppWeb(wechatInAppWeb);
        return payerInfo;
    }
}
