package cn.payingcloud.umf;

import cn.payingcloud.umf.model.*;

public class PayerBuilder {
    private final PaymentMethod paymentMethod;//支付方式
    private final InterfaceType interfaceType;
    private final BusinessType businessType;
    private BankCode bankCode;            //银行编码
    private final PayerInfo payerInfo;        //付款人详细信息

    public static PayerBuilder ofWxScanCode(PayerInfo payerInfo) {
        return new PayerBuilder(
                PaymentMethod.WECHAT_SCAN,
                InterfaceType.SERVER_TO_SERVER,
                BusinessType.B2C,
                payerInfo);
    }

    public static PayerBuilder ofAliScanCode(PayerInfo payerInfo) {
        return new PayerBuilder(
                PaymentMethod.ALIPAY_SCAN,
                InterfaceType.SERVER_TO_SERVER,
                BusinessType.B2C,
                payerInfo);
    }

    public static PayerBuilder ofBankDebit(PayerInfo payerInfo, BankCode bankCode) {
        PayerBuilder payerBuilder = new PayerBuilder(PaymentMethod.DEBIT_CARD,
                InterfaceType.SERVER_TO_SERVER,
                BusinessType.B2C,
                payerInfo);
        payerBuilder.setBankCode(bankCode);
        return payerBuilder;
    }

    public static PayerBuilder ofBankCredit(PayerInfo payerInfo, BankCode bankCode) {
        PayerBuilder payerBuilder = new PayerBuilder(PaymentMethod.CREDIT_CARD,
                InterfaceType.SERVER_TO_SERVER,
                BusinessType.B2C,
                payerInfo);
        payerBuilder.setBankCode(bankCode);
        return payerBuilder;
    }

    public static PayerBuilder ofWxWeb(PayerInfo payerInfo) {
        return new PayerBuilder(PaymentMethod.WECHAT_WEB,
                InterfaceType.SERVER_TO_SERVER,
                BusinessType.B2C,
                payerInfo);

    }

    public static PayerBuilder ofWxApp(PayerInfo payerInfo) {
        return new PayerBuilder(PaymentMethod.WECHAT_IN_APP,
                InterfaceType.SERVER_TO_SERVER,
                BusinessType.B2C,
                payerInfo);
    }

    private PayerBuilder(PaymentMethod paymentMethod, InterfaceType interfaceType, BusinessType businessType, PayerInfo payerInfo) {
        this.paymentMethod = paymentMethod;
        this.interfaceType = interfaceType;
        this.businessType = businessType;
        this.payerInfo = payerInfo;
    }

    public PaymentMethod getPaymentMethod() {
        return paymentMethod;
    }

    public InterfaceType getInterfaceType() {
        return interfaceType;
    }

    public BusinessType getBusinessType() {
        return businessType;
    }

    public BankCode getBankCode() {
        return bankCode;
    }

    public void setBankCode(BankCode bankCode) {
        this.bankCode = bankCode;
    }

    public PayerInfo getPayerInfo() {
        return payerInfo;
    }

    public Payer build() {
        Payer payer = new Payer();
        payer.setPaymentMethod(paymentMethod);
        payer.setBusinessType(businessType);
        payer.setInterfaceType(interfaceType);
        if (bankCode != null) {
            payer.setBankCode(bankCode.name());
        }
        payer.setPayerInfo(payerInfo);
        return payer;
    }
}
