/*
 * Decompiled with CFR 0.152.
 */
package cn.payingcloud.umf.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Base64;
import org.apache.commons.codec.digest.DigestUtils;

public class StreamUtils {
    private static final int BUFFER_SIZE = 4096;

    private StreamUtils() {
    }

    public static InputStream loadResource(String name) {
        return StreamUtils.class.getResourceAsStream(name);
    }

    public static String[] base64(InputStream in) {
        String[] result = new String[2];
        byte[] bytes = StreamUtils.copyToByteArray(in);
        result[0] = Base64.getEncoder().encodeToString(bytes);
        result[1] = DigestUtils.md5Hex((byte[])bytes);
        return result;
    }

    public static byte[] copyToByteArray(InputStream in) {
        if (in == null) {
            throw new IllegalArgumentException("No InputStream specified");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        StreamUtils.copy(in, (OutputStream)out);
        return out.toByteArray();
    }

    public static String copyToString(InputStream in, Charset charset) {
        if (in == null) {
            throw new IllegalArgumentException("No InputStream specified");
        }
        if (charset == null) {
            throw new IllegalArgumentException("No Charset specified");
        }
        try {
            int bytesRead;
            StringBuilder out = new StringBuilder();
            InputStreamReader reader = new InputStreamReader(in, charset);
            char[] buffer = new char[4096];
            while ((bytesRead = reader.read(buffer)) != -1) {
                out.append(buffer, 0, bytesRead);
            }
            return out.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void copy(byte[] in, OutputStream out) {
        if (in == null) {
            throw new IllegalArgumentException("No input byte array specified");
        }
        if (out == null) {
            throw new IllegalArgumentException("No OutputStream specified");
        }
        try {
            out.write(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void copy(String in, Charset charset, OutputStream out) {
        if (in == null) {
            throw new IllegalArgumentException("No input byte array specified");
        }
        if (out == null) {
            throw new IllegalArgumentException("No OutputStream specified");
        }
        if (charset == null) {
            throw new IllegalArgumentException("No Charset specified");
        }
        try {
            OutputStreamWriter writer = new OutputStreamWriter(out, charset);
            writer.write(in);
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static int copy(InputStream in, OutputStream out) {
        try {
            int bytesRead;
            if (in == null) {
                throw new IllegalArgumentException("No InputStream specified");
            }
            if (out == null) {
                throw new IllegalArgumentException("No OutputStream specified");
            }
            int byteCount = 0;
            byte[] buffer = new byte[4096];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
            }
            out.flush();
            return byteCount;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

