/*
 * Decompiled with CFR 0.152.
 */
package cn.payingcloud.umf.util;

import cn.payingcloud.umf.UmfException;
import cn.payingcloud.umf.util.HttpUtils;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.Base64;

public class SignUtils {
    private SignUtils() {
    }

    public static String sign(PrivateKey privateKey, String data) {
        try {
            Signature e = Signature.getInstance("SHA256withRSA");
            e.initSign(privateKey);
            e.update(data.getBytes(HttpUtils.CHARSET));
            byte[] sign = e.sign();
            return Base64.getEncoder().encodeToString(sign);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new UmfException(e);
        }
    }

    public static boolean verify(X509Certificate certificate, String sign, String data) {
        try {
            Signature e = Signature.getInstance("SHA256withRSA");
            e.initVerify(certificate);
            e.update(data.getBytes(HttpUtils.CHARSET));
            return e.verify(Base64.getDecoder().decode(sign));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new UmfException(e);
        }
        catch (SignatureException e) {
            return false;
        }
    }
}

