/*
 * Decompiled with CFR 0.152.
 */
package cn.payingcloud.umf.util;

import cn.payingcloud.umf.UmfException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class HttpUtils {
    public static final String SIGN_HTTP_HEADER = "Signature";
    public static final String AUTH_HTTP_HEADER = "Authorization";
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    private static CloseableHttpClient httpClient = HttpClients.createDefault();

    private HttpUtils() {
    }

    public static String doPost(String url, String json, String token, String sign) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader(AUTH_HTTP_HEADER, "Bearer " + token);
        httpPost.setHeader(SIGN_HTTP_HEADER, sign);
        httpPost.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
        return HttpUtils.send((HttpUriRequest)httpPost);
    }

    public static String doPost(String url, String json) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
        return HttpUtils.send((HttpUriRequest)httpPost);
    }

    public static String doGet(String url, String token) {
        HttpGet httpGet = new HttpGet(url);
        httpGet.setHeader(AUTH_HTTP_HEADER, "Bearer " + token);
        return HttpUtils.send((HttpUriRequest)httpGet);
    }

    private static String send(HttpUriRequest request) {
        try {
            CloseableHttpResponse response = httpClient.execute(request);
            return EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            throw new UmfException(e);
        }
    }
}

