/*
 * Decompiled with CFR 0.152.
 */
package cn.payingcloud.umf.util;

import cn.payingcloud.umf.UmfException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class CipherUtils {
    private CipherUtils() {
    }

    public static String encrypt(String plain, X509Certificate cert) {
        if (plain == null) {
            return null;
        }
        try {
            byte[] keyBytes = cert.getPublicKey().getEncoded();
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(1, publicKey);
            byte[] plainBytes = plain.getBytes(StandardCharsets.UTF_8);
            byte[] secretBytes = cipher.doFinal(plainBytes);
            return Base64.getEncoder().encodeToString(secretBytes);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new UmfException(e);
        }
    }
}

