/*
 * Decompiled with CFR 0.152.
 */
package cn.payingcloud.umf;

import cn.payingcloud.umf.CallbackRequest;
import cn.payingcloud.umf.PlaceOrderResponse;
import cn.payingcloud.umf.QueryOrderResponse;
import cn.payingcloud.umf.QueryRefundResponse;
import cn.payingcloud.umf.QueryTransactionResponse;
import cn.payingcloud.umf.RefundResponse;
import cn.payingcloud.umf.Response;
import cn.payingcloud.umf.TokenProvider;
import cn.payingcloud.umf.UmfException;
import cn.payingcloud.umf.UmfProfile;
import cn.payingcloud.umf.model.AccessToken;
import cn.payingcloud.umf.model.Payment;
import cn.payingcloud.umf.model.PaymentMethod;
import cn.payingcloud.umf.model.Refund;
import cn.payingcloud.umf.util.HttpUtils;
import cn.payingcloud.umf.util.JsonUtils;
import cn.payingcloud.umf.util.SignUtils;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UmfClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmfClient.class);
    private final UmfProfile profile;
    private final PrivateKey privateKey;
    private final X509Certificate certificate;
    private final TokenProvider tokenProvider;
    private boolean verifyCallbackSign = true;
    private boolean verifyResponseSign = false;

    public UmfClient(UmfProfile profile, PrivateKey privateKey, X509Certificate certificate, TokenProvider tokenProvider) {
        Validate.notNull((Object)((Object)profile), (String)"profile must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)privateKey, (String)"privateKey must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)certificate, (String)"certificate must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)tokenProvider, (String)"tokenProvider must not be null", (Object[])new Object[0]);
        this.profile = profile;
        this.privateKey = privateKey;
        this.certificate = certificate;
        this.tokenProvider = tokenProvider;
    }

    public void setVerifyCallbackSign(boolean verifyCallbackSign) {
        this.verifyCallbackSign = verifyCallbackSign;
    }

    public void setVerifyResponseSign(boolean verifyResponseSign) {
        this.verifyResponseSign = verifyResponseSign;
    }

    public static AccessToken getAccessToken(UmfProfile profile, String clientId, String clientSecret) {
        String url = profile.getUrl() + "/oauth/authorize";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", clientId);
        params.put("client_secret", clientSecret);
        params.put("grant_type", "client_credentials");
        String json = JsonUtils.toJson(params);
        String response = HttpUtils.doPost(url, json);
        return JsonUtils.fromJson(response, AccessToken.class);
    }

    public PlaceOrderResponse placeOrder(Payment payment) {
        payment.encrypt(this.certificate);
        String url = this.profile.getUrl() + "/payments/payment";
        PlaceOrderResponse response = this.post(url, payment, PlaceOrderResponse.class);
        if (response.successful() && this.isBankCardPay(payment)) {
            payment.setId(response.getPaymentId());
            return this.verifyCode(payment);
        }
        return response;
    }

    public PlaceOrderResponse execute(Payment payment) {
        Validate.notNull((Object)payment, (String)"payment can't be null", (Object[])new Object[0]);
        String url = this.profile.getUrl() + "/payments/payment/" + payment.getId() + "/execute";
        return this.post(url, payment, PlaceOrderResponse.class);
    }

    public QueryOrderResponse queryOrder(String paymentId) {
        Validate.notNull((Object)paymentId, (String)"paymentId can't be null", (Object[])new Object[0]);
        String url = this.profile.getUrl() + "/payments/payment/" + paymentId;
        return this.get(url, QueryOrderResponse.class);
    }

    public RefundResponse refund(String paymentId, Refund refund) {
        Validate.notNull((Object)paymentId, (String)"paymentId can't be null", (Object[])new Object[0]);
        String url = this.profile.getUrl() + "/payments/payment/" + paymentId + "/refund";
        return this.post(url, refund, RefundResponse.class);
    }

    public QueryRefundResponse queryRefund(String refundId) {
        Validate.notNull((Object)refundId, (String)"refundId can't be null", (Object[])new Object[0]);
        String url = this.profile.getUrl() + "/payments/refund/" + refundId;
        return this.get(url, QueryRefundResponse.class);
    }

    public QueryTransactionResponse queryTransaction(Date date) {
        String merDate = DateFormatUtils.format((Date)date, (String)"yyMMdd");
        String url = this.profile.getUrl() + "/payments/?mer_date=" + merDate;
        return this.get(url, QueryTransactionResponse.class);
    }

    public <T extends CallbackRequest> T resolveCallbackRequest(String sign, String data, Class<T> tClass) {
        LOGGER.debug("Resolving Callback Request, Sign: {}, Json: {}", (Object)sign, (Object)data);
        if (this.verifyCallbackSign && !SignUtils.verify(this.certificate, sign, data)) {
            throw new UmfException("Failed to pass callback sign verification");
        }
        return (T)((CallbackRequest)JsonUtils.fromJson(data, tClass));
    }

    public String generateCallbackResponseData(CallbackRequest callback) {
        return "{\"meta\":{\"ret_code\":\"0000\",\"ret_msg\":[\"SUCCESS\"]}}";
    }

    private PlaceOrderResponse verifyCode(Payment payment) {
        Validate.notNull((Object)payment, (String)"payment can't be null", (Object[])new Object[0]);
        String url = this.profile.getUrl() + "/payments/payment/" + payment.getId() + "/verify";
        return this.post(url, payment, PlaceOrderResponse.class);
    }

    private <T extends Response> T get(String url, Class<T> tClass) {
        LOGGER.debug("Send Request, Url: {}", (Object)url);
        String response = HttpUtils.doGet(url, this.tokenProvider.getToken());
        LOGGER.debug("Response Json: {} ", (Object)response);
        Response result = (Response)JsonUtils.fromJson(response, tClass);
        if (this.verifyResponseSign && result.successful()) {
            SignUtils.verify(this.certificate, result.getMeta().getSign(), response);
        }
        return (T)result;
    }

    private <T extends Response> T post(String url, Object obj, Class<T> tClass) {
        String json = JsonUtils.toJson(obj);
        LOGGER.debug("Send Request, Url: {}, Json: {}", (Object)url, (Object)json);
        String sign = SignUtils.sign(this.privateKey, json);
        String response = HttpUtils.doPost(url, json, this.tokenProvider.getToken(), sign);
        LOGGER.debug("Response Json: {} ", (Object)response);
        Response result = (Response)JsonUtils.fromJson(response, tClass);
        if (this.verifyResponseSign && result.successful()) {
            SignUtils.verify(this.certificate, result.getMeta().getSign(), response);
        }
        return (T)result;
    }

    private boolean isBankCardPay(Payment payment) {
        return PaymentMethod.CREDIT_CARD == payment.getPayer().getPaymentMethod() || PaymentMethod.DEBIT_CARD == payment.getPayer().getPaymentMethod();
    }
}

