/*
 * Decompiled with CFR 0.152.
 */
package cn.payingcloud.umf;

import cn.payingcloud.umf.PayerBuilder;
import cn.payingcloud.umf.PayerInfoBuilder;
import cn.payingcloud.umf.model.BankCard;
import cn.payingcloud.umf.model.BankCode;
import cn.payingcloud.umf.model.Order;
import cn.payingcloud.umf.model.Payer;
import cn.payingcloud.umf.model.Payment;
import cn.payingcloud.umf.model.QrCodeScan;
import cn.payingcloud.umf.model.RiskInfo;
import cn.payingcloud.umf.model.WechatInApp;
import cn.payingcloud.umf.model.WechatInAppWeb;

public class PaymentBuilder {
    private final Payer payer;
    private final Order order;
    private final String notifyUrl;
    private String retUrl;
    private final RiskInfo riskInfo;

    public static PaymentBuilder ofWxScanCode(String name, String phone, String citizenIdNumber, Order order, String notifyUrl, RiskInfo riskInfo) {
        QrCodeScan qrCodeScan = new QrCodeScan(citizenIdNumber);
        PayerInfoBuilder payerInfoBuilder = PayerInfoBuilder.ofCodeScan(phone, qrCodeScan);
        payerInfoBuilder.setName(name);
        PayerBuilder payerBuilder = PayerBuilder.ofWxScanCode(payerInfoBuilder.build());
        return new PaymentBuilder(payerBuilder.build(), order, notifyUrl, riskInfo);
    }

    public static PaymentBuilder ofAliScanCode(String name, String phone, String citizenIdNumber, Order order, String notifyUrl, RiskInfo riskInfo) {
        QrCodeScan qrCodeScan = new QrCodeScan(citizenIdNumber);
        PayerInfoBuilder payerInfoBuilder = PayerInfoBuilder.ofCodeScan(phone, qrCodeScan);
        payerInfoBuilder.setName(name);
        PayerBuilder payerBuilder = PayerBuilder.ofAliScanCode(payerInfoBuilder.build());
        return new PaymentBuilder(payerBuilder.build(), order, notifyUrl, riskInfo);
    }

    public static PaymentBuilder ofBank(String phone, BankCard bankCard, BankCode bankCode, Order order, String notifyUrl, RiskInfo riskInfo) {
        PayerInfoBuilder payerInfoBuilder = PayerInfoBuilder.ofBankCard(phone, bankCard);
        PayerBuilder payerBuilder = bankCard.getCvv2() != null || bankCard.getValidDate() != null ? PayerBuilder.ofBankCredit(payerInfoBuilder.build(), bankCode) : PayerBuilder.ofBankDebit(payerInfoBuilder.build(), bankCode);
        return new PaymentBuilder(payerBuilder.build(), order, notifyUrl, riskInfo);
    }

    public static PaymentBuilder ofWxWeb(String name, String phone, String citizenIdNumber, Order order, String notifyUrl, RiskInfo riskInfo) {
        WechatInAppWeb wechatInAppWeb = new WechatInAppWeb(citizenIdNumber);
        PayerInfoBuilder payerInfoBuilder = PayerInfoBuilder.ofWxWeb(phone, wechatInAppWeb);
        payerInfoBuilder.setName(name);
        PayerBuilder payerBuilder = PayerBuilder.ofWxWeb(payerInfoBuilder.build());
        return new PaymentBuilder(payerBuilder.build(), order, notifyUrl, riskInfo);
    }

    public static PaymentBuilder ofWxApp(String name, String phone, String citizenIdNumber, Order order, String notifyUrl, RiskInfo riskInfo) {
        WechatInApp wechatInApp = new WechatInApp();
        PayerInfoBuilder payerInfoBuilder = PayerInfoBuilder.ofWxApp(phone, wechatInApp);
        payerInfoBuilder.setName(name);
        PayerBuilder payerBuilder = PayerBuilder.ofWxApp(payerInfoBuilder.build());
        return new PaymentBuilder(payerBuilder.build(), order, notifyUrl, riskInfo);
    }

    private PaymentBuilder(Payer payer, Order order, String notifyUrl, RiskInfo riskInfo) {
        this.payer = payer;
        this.order = order;
        this.notifyUrl = notifyUrl;
        this.riskInfo = riskInfo;
    }

    public Payer getPayer() {
        return this.payer;
    }

    public Order getOrder() {
        return this.order;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public String getRetUrl() {
        return this.retUrl;
    }

    public void setRetUrl(String retUrl) {
        this.retUrl = retUrl;
    }

    public RiskInfo getRiskInfo() {
        return this.riskInfo;
    }

    public Payment build() {
        Payment payment = new Payment();
        payment.setPayer(this.payer);
        payment.setOrder(this.order);
        payment.setNotifyUrl(this.notifyUrl);
        payment.setRetUrl(this.retUrl);
        payment.setRiskInfo(this.riskInfo);
        return payment;
    }
}

