/*
 * Decompiled with CFR 0.152.
 */
package cn.payingcloud.umf;

import cn.payingcloud.umf.model.BankCard;
import cn.payingcloud.umf.model.PayerAgreement;
import cn.payingcloud.umf.model.PayerInfo;
import cn.payingcloud.umf.model.QrCodeScan;
import cn.payingcloud.umf.model.WechatInApp;
import cn.payingcloud.umf.model.WechatInAppWeb;

public class PayerInfoBuilder {
    private BankCard bankCard;
    private QrCodeScan qrCodeScan;
    private PayerAgreement payerAgreement;
    private final String phone;
    private String name;
    private WechatInApp wechatInApp;
    private WechatInAppWeb wechatInAppWeb;

    public static PayerInfoBuilder ofBankCard(String phone, BankCard bankCard) {
        PayerInfoBuilder builder = new PayerInfoBuilder(phone);
        builder.setBankCard(bankCard);
        return builder;
    }

    public static PayerInfoBuilder ofCodeScan(String phone, QrCodeScan codeScan) {
        PayerInfoBuilder builder = new PayerInfoBuilder(phone);
        builder.setQrCodeScan(codeScan);
        return builder;
    }

    public static PayerInfoBuilder ofWxWeb(String phone, WechatInAppWeb wechatInAppWeb) {
        PayerInfoBuilder builder = new PayerInfoBuilder(phone);
        builder.setWechatInAppWeb(wechatInAppWeb);
        return builder;
    }

    public static PayerInfoBuilder ofWxApp(String phone, WechatInApp wechatInApp) {
        PayerInfoBuilder builder = new PayerInfoBuilder(phone);
        builder.setWechatInApp(wechatInApp);
        return builder;
    }

    private PayerInfoBuilder(String phone) {
        this.phone = phone;
    }

    public BankCard getBankCard() {
        return this.bankCard;
    }

    public void setBankCard(BankCard bankCard) {
        this.bankCard = bankCard;
    }

    public QrCodeScan getQrCodeScan() {
        return this.qrCodeScan;
    }

    public void setQrCodeScan(QrCodeScan qrCodeScan) {
        this.qrCodeScan = qrCodeScan;
    }

    public PayerAgreement getPayerAgreement() {
        return this.payerAgreement;
    }

    public void setPayerAgreement(PayerAgreement payerAgreement) {
        this.payerAgreement = payerAgreement;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WechatInApp getWechatInApp() {
        return this.wechatInApp;
    }

    public void setWechatInApp(WechatInApp wechatInApp) {
        this.wechatInApp = wechatInApp;
    }

    public WechatInAppWeb getWechatInAppWeb() {
        return this.wechatInAppWeb;
    }

    public void setWechatInAppWeb(WechatInAppWeb wechatInAppWeb) {
        this.wechatInAppWeb = wechatInAppWeb;
    }

    public PayerInfo build() {
        PayerInfo payerInfo = new PayerInfo();
        payerInfo.setPhone(this.phone);
        payerInfo.setName(this.name);
        payerInfo.setBankCard(this.bankCard);
        payerInfo.setQrCodeScan(this.qrCodeScan);
        payerInfo.setPayerAgreement(this.payerAgreement);
        payerInfo.setWechatInApp(this.wechatInApp);
        payerInfo.setWechatInAppWeb(this.wechatInAppWeb);
        return payerInfo;
    }
}

