/*
 * Decompiled with CFR 0.152.
 */
package cn.payingcloud.umf.model;

import cn.payingcloud.umf.model.Amount;
import cn.payingcloud.umf.model.CurrencyType;
import cn.payingcloud.umf.model.SubOrder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateFormatUtils;

public class Order {
    @JsonProperty(value="mer_reference_id")
    private String merReferenceId;
    @JsonProperty(value="mer_date")
    private String merDate;
    private Amount amount;
    @JsonProperty(value="order_summary")
    private String orderSummary;
    @JsonProperty(value="expire_time")
    private String expireTime;
    @JsonProperty(value="user_ip")
    private String userIp;
    @JsonProperty(value="sub_orders")
    private List<SubOrder> subOrders;

    Order() {
    }

    public Order(String merReferenceId, Amount amount, String orderSummary, String userIp) {
        this.merReferenceId = merReferenceId;
        this.merDate = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd");
        this.amount = amount;
        this.amount.setCurrency(CurrencyType.CNY.toString());
        this.orderSummary = orderSummary;
        this.userIp = userIp;
        this.subOrders = new ArrayList<SubOrder>();
    }

    public Order addSubOrder(SubOrder subOrder) {
        this.subOrders.add(subOrder);
        return this;
    }

    public void setAmountTotal(SubOrder subOrder) {
        double to = Double.parseDouble(this.amount.getTotal());
        String total = (to += Double.parseDouble(subOrder.getAmount().getTotal())) + "";
        this.amount.setTotal(total);
    }

    public String getMerReferenceId() {
        return this.merReferenceId;
    }

    public void setMerReferenceId(String merReferenceId) {
        this.merReferenceId = merReferenceId;
    }

    public String getMerDate() {
        return this.merDate;
    }

    public void setMerDate(String merDate) {
        this.merDate = merDate;
    }

    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public String getOrderSummary() {
        return this.orderSummary;
    }

    public void setOrderSummary(String orderSummary) {
        this.orderSummary = orderSummary;
    }

    public String getExpireTime() {
        return this.expireTime;
    }

    void setExpireTime(String expireTime) {
        this.expireTime = expireTime;
    }

    public String getUserIp() {
        return this.userIp;
    }

    public void setUserIp(String userIp) {
        this.userIp = userIp;
    }

    public List<SubOrder> getSubOrders() {
        return this.subOrders;
    }

    public void setSubOrders(List<SubOrder> subOrders) {
        this.subOrders = subOrders;
    }

    public void expireTime(int seconds) {
        this.expireTime = seconds + "";
    }
}

