/*
 * Decompiled with CFR 0.152.
 */
package cn.payingcloud.umf;

import cn.payingcloud.umf.model.BankCode;
import cn.payingcloud.umf.model.BusinessType;
import cn.payingcloud.umf.model.InterfaceType;
import cn.payingcloud.umf.model.Payer;
import cn.payingcloud.umf.model.PayerInfo;
import cn.payingcloud.umf.model.PaymentMethod;

public class PayerBuilder {
    private final PaymentMethod paymentMethod;
    private final InterfaceType interfaceType;
    private final BusinessType businessType;
    private BankCode bankCode;
    private final PayerInfo payerInfo;

    public static PayerBuilder ofWxScanCode(PayerInfo payerInfo) {
        return new PayerBuilder(PaymentMethod.WECHAT_SCAN, InterfaceType.SERVER_TO_SERVER, BusinessType.B2C, payerInfo);
    }

    public static PayerBuilder ofAliScanCode(PayerInfo payerInfo) {
        return new PayerBuilder(PaymentMethod.ALIPAY_SCAN, InterfaceType.SERVER_TO_SERVER, BusinessType.B2C, payerInfo);
    }

    public static PayerBuilder ofBankDebit(PayerInfo payerInfo, BankCode bankCode) {
        PayerBuilder payerBuilder = new PayerBuilder(PaymentMethod.DEBIT_CARD, InterfaceType.SERVER_TO_SERVER, BusinessType.B2C, payerInfo);
        payerBuilder.setBankCode(bankCode);
        return payerBuilder;
    }

    public static PayerBuilder ofBankCredit(PayerInfo payerInfo, BankCode bankCode) {
        PayerBuilder payerBuilder = new PayerBuilder(PaymentMethod.CREDIT_CARD, InterfaceType.SERVER_TO_SERVER, BusinessType.B2C, payerInfo);
        payerBuilder.setBankCode(bankCode);
        return payerBuilder;
    }

    public static PayerBuilder ofWxWeb(PayerInfo payerInfo) {
        return new PayerBuilder(PaymentMethod.WECHAT_WEB, InterfaceType.SERVER_TO_SERVER, BusinessType.B2C, payerInfo);
    }

    public static PayerBuilder ofWxApp(PayerInfo payerInfo) {
        return new PayerBuilder(PaymentMethod.WECHAT_IN_APP, InterfaceType.SERVER_TO_SERVER, BusinessType.B2C, payerInfo);
    }

    private PayerBuilder(PaymentMethod paymentMethod, InterfaceType interfaceType, BusinessType businessType, PayerInfo payerInfo) {
        this.paymentMethod = paymentMethod;
        this.interfaceType = interfaceType;
        this.businessType = businessType;
        this.payerInfo = payerInfo;
    }

    public PaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    public InterfaceType getInterfaceType() {
        return this.interfaceType;
    }

    public BusinessType getBusinessType() {
        return this.businessType;
    }

    public BankCode getBankCode() {
        return this.bankCode;
    }

    public void setBankCode(BankCode bankCode) {
        this.bankCode = bankCode;
    }

    public PayerInfo getPayerInfo() {
        return this.payerInfo;
    }

    public Payer build() {
        Payer payer = new Payer();
        payer.setPaymentMethod(this.paymentMethod);
        payer.setBusinessType(this.businessType);
        payer.setInterfaceType(this.interfaceType);
        payer.setBankCode(this.bankCode);
        payer.setPayerInfo(this.payerInfo);
        return payer;
    }
}

