package cn.payingcloud.umf.util;

import java.nio.charset.StandardCharsets;
import java.security.*;
import java.util.Base64;

public class SignUtils {

    private SignUtils() {
    }

    public static String sign(PrivateKey privateKey, String data) {
        try {
            Signature e = Signature.getInstance("SHA256withRSA");
            e.initSign(privateKey);
            e.update(data.getBytes(StandardCharsets.UTF_8));
            byte[] sign = e.sign();
            return Base64.getEncoder().encodeToString(sign);
        } catch (NoSuchAlgorithmException | SignatureException | InvalidKeyException e) {
            throw new RuntimeException(e);
        }
    }

}
