package cn.payingcloud.umf.model;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * 微信支付信息实体类
 */
public class WechatPay {
    @JsonProperty("citizen_id_number")
    private String citizenIdNumber;    //证件号码(RSA)

    @JsonProperty("citizen_id_type")
    private String citizenIdType;    //证件类型

    @JsonProperty("payer_name")
    private String payerName;        //支付人的姓名（RSA）

    @JsonProperty("bank_payurl")
    private String bankPayurl;        //融合支付主扫二维码链接地址

    @JsonProperty("open_id")
    private String openId;            //公众号获取授权时返回,下单时传入

    @JsonProperty("pay_info")
    private String payInfo;            //下单时返回,app支付所需参数组成的json串

    public String getCitizenIdNumber() {
        return citizenIdNumber;
    }

    public void setCitizenIdNumber(String citizenIdNumber) {
        this.citizenIdNumber = citizenIdNumber;
    }

    public String getCitizenIdType() {
        return citizenIdType;
    }

    public void setCitizenIdType(String citizenIdType) {
        this.citizenIdType = citizenIdType;
    }

    public String getPayerName() {
        return payerName;
    }

    public void setPayerName(String payerName) {
        this.payerName = payerName;
    }

    public String getBankPayurl() {
        return bankPayurl;
    }

    public void setBankPayurl(String bankPayurl) {
        this.bankPayurl = bankPayurl;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getPayInfo() {
        return payInfo;
    }

    public void setPayInfo(String payInfo) {
        this.payInfo = payInfo;
    }
}
