package cn.payingcloud.umf.model;

import cn.payingcloud.umf.util.CipherUtils;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.security.cert.X509Certificate;

public class WechatInAppWeb {

    @JsonProperty("citizen_id_type")
    private String citizenIdType;

    @JsonProperty("citizen_id_number")
    private String citizenIdNumber = CitizenIdType.IDENTITY_CARD.getCode();

    @JsonProperty("open_id")
    private String openId;

    @JsonProperty("pay_info")
    private PayInfo payInfo;

    WechatInAppWeb() {
    }

    public WechatInAppWeb(String citizenIdNumber) {
        this.citizenIdNumber = citizenIdNumber;
    }

    public String getCitizenIdType() {
        return citizenIdType;
    }

    public void setCitizenIdType(String citizenIdType) {
        this.citizenIdType = citizenIdType;
    }

    public String getCitizenIdNumber() {
        return citizenIdNumber;
    }

    public void setCitizenIdNumber(String citizenIdNumber) {
        this.citizenIdNumber = citizenIdNumber;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public PayInfo getPayInfo() {
        return payInfo;
    }

    public void setPayInfo(PayInfo payInfo) {
        this.payInfo = payInfo;
    }

    public void encrypt(X509Certificate certificate) {
        citizenIdNumber = CipherUtils.encrypt(citizenIdNumber, certificate);
    }
}
