package cn.payingcloud.umf.model;

/**
 * 退费信息-退费状态枚举类
 */
public enum RefundState {

    REFUND_SUCCESS,        //退费成功  数据库状态 6               ret_code=0000
    REFUND_FAIL,        //退费失败 数据库状态 3、4、8、14                         当退费由于网络等诸多因素造成超时时，会返回此状态。
    REFUND_PROCESS,        //退费处理中 数据库状态 1、5、7、10、11   ret_code=00060861&ret_msg=财务打款中 为退款请求发起成功
    MER_PROCESS,        //退费商户处理中 数据库状态 12、16
    REFUND_UNKNOWN,        //退费退费结果不明 -1
    REFUND_WAIT_AUDIT,    //退费待审核 数据库状态13、15
    REFUND_CLOSE,    //退费关闭	退款失败返回状态
    REFUND_ORIGINAL,    //初始
    REFUND_NOTNEED,        //无需退费
    REFUND_PAY_NOT_SUCCESS;//退单不付

    // 根据整型获取英文退费状态类型
    public static RefundState getStringRefundState(int valueInt) {
        RefundState refundState = REFUND_PROCESS;
        switch (valueInt) {
            case 6:
                //退费成功 6
                refundState = REFUND_SUCCESS;
                break;
            case 3:
            case 4:
            case 8:
            case 14:
                //,4,8,14 退费失败
                refundState = REFUND_FAIL;
                break;
            case 1:
            case 5:
            case 7:
            case 10:
            case 11:
                //退费处理中  处理中1 ,5,7,10,11,
                refundState = REFUND_PROCESS;
                break;
            case 12:
            case 16:
                //退费处理中  商户处理中12,16
                refundState = MER_PROCESS;
                break;
            case 13:
            case 15:
                //待审核 13,15
                refundState = REFUND_WAIT_AUDIT;
                break;
            case -1:
            case -99:
                //退费结果不明 -1,-99
                refundState = REFUND_UNKNOWN;
                break;
        }
        return refundState;

    }
}
