package cn.payingcloud.umf.model;

import cn.payingcloud.umf.util.CipherUtils;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.security.cert.X509Certificate;

public class QrCodeScan {

    @JsonProperty("citizen_id_type")
    private String citizenIdType = CitizenIdType.IDENTITY_CARD.getCode();

    @JsonProperty("citizen_id_number")
    private String citizenIdNumber;

    @JsonProperty("qr_code_url")
    private String qrCodeUrl;

    QrCodeScan() {
    }

    public QrCodeScan(String citizenIdNumber) {
        this.citizenIdNumber = citizenIdNumber;
    }

    public String getCitizenIdType() {
        return citizenIdType;
    }

    public void setCitizenIdType(String citizenIdType) {
        this.citizenIdType = citizenIdType;
    }

    public String getCitizenIdNumber() {
        return citizenIdNumber;
    }

    public void setCitizenIdNumber(String citizenIdNumber) {
        this.citizenIdNumber = citizenIdNumber;
    }

    public String getQrCodeUrl() {
        return qrCodeUrl;
    }

    public void setQrCodeUrl(String qrCodeUrl) {
        this.qrCodeUrl = qrCodeUrl;
    }

    public void encrypt(X509Certificate certificate) {
        citizenIdNumber = CipherUtils.encrypt(citizenIdNumber, certificate);
    }
}
