package cn.payingcloud.umf.model;

/**
 * 支付信息-订单状态枚举类
 */
public enum PaymentState {
    WAIT_BUYER_PAY,    //交易创建，等待买家付款。
    TRADE_SUCCESS,    //交易成功，不能再次进行交易
    TRADE_CANCEL,    //交易撤销
    TRADE_CLOSED,    //交易关闭，在指定时间段内未支付时关闭的交易
    TRADE_FAIL;    //交易失败

    // 根据整型获取英文订单类型
    public static PaymentState getStringPaymentState(int valueInt) {
        PaymentState paymentState = WAIT_BUYER_PAY;
        switch (valueInt) {
            case -99:
                paymentState = WAIT_BUYER_PAY;
                break;
            case 0:
                paymentState = WAIT_BUYER_PAY;
                break;
            case 1:
                paymentState = WAIT_BUYER_PAY;
                break;
            case 2:
                paymentState = TRADE_SUCCESS;
                break;
            case 3:
                paymentState = TRADE_FAIL;
                break;
            case 4:
                paymentState = TRADE_SUCCESS;
                break;
            case 5:
                paymentState = TRADE_CANCEL;
                break;
            case 6:
                paymentState = TRADE_CLOSED;
                break;
            case -1:
                paymentState = TRADE_FAIL;
                break;
        }
        return paymentState;

    }
}
