package cn.payingcloud.umf.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.security.cert.X509Certificate;

/**
 * 支付信息实体类
 */
public class Payment {

    private Payer payer;                //付款信息

    private Order order;                //订单信息

    private String id;

    @JsonProperty("notify_url")
    private String notifyUrl;            //结果后台通知

    @JsonProperty("ret_url")
    private String retUrl;                //结果前台通知

    @JsonProperty("risk_info")
    private RiskInfo riskInfo;            //风控对象

    @JsonProperty("mer_check_date")
    private String merCheckDate;        //对账日期

    private PaymentState state;            //交易状态

    @JsonProperty("pay_elements")
    private String payElements;            //支付要素结合

    @JsonProperty("settle_date")
    private String settleDate;            //对账日期

    @JsonProperty("execute_success_time")
    private String executeSuccessTime;    //扣款成功时间

    @JsonProperty("is_from_US")
    private String isFromUs;

    public String getIsFromUs() {
        return isFromUs;
    }

    public void setIsFromUs(String isFromUs) {
        this.isFromUs = isFromUs;
    }

    public Payer getPayer() {
        return payer;
    }

    public void setPayer(Payer payer) {
        this.payer = payer;
    }

    public Order getOrder() {
        return order;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getRetUrl() {
        return retUrl;
    }

    public void setRetUrl(String retUrl) {
        this.retUrl = retUrl;
    }

    public RiskInfo getRiskInfo() {
        return riskInfo;
    }

    public void setRiskInfo(RiskInfo riskInfo) {
        this.riskInfo = riskInfo;
    }

    public String getMerCheckDate() {
        return merCheckDate;
    }

    public void setMerCheckDate(String merCheckDate) {
        this.merCheckDate = merCheckDate;
    }

    public PaymentState getState() {
        return state;
    }

    public void setState(PaymentState state) {
        this.state = state;
    }

    public String getPayElements() {
        return payElements;
    }

    public void setPayElements(String payElements) {
        this.payElements = payElements;
    }

    public String getSettleDate() {
        return settleDate;
    }

    public void setSettleDate(String settleDate) {
        this.settleDate = settleDate;
    }

    public String getExecuteSuccessTime() {
        return executeSuccessTime;
    }

    public void setExecuteSuccessTime(String executeSuccessTime) {
        this.executeSuccessTime = executeSuccessTime;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void encrypt(X509Certificate certificate) {
        if (payer != null) {
            payer.encrypt(certificate);
        }
    }
}
