package cn.payingcloud.umf.model;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * 协议支付信息实体类
 */
public class PayerAgreement {
    @JsonProperty("gate_id")
    private String gateId;                //支付使用的银行编码

    @JsonProperty("last_four_cardid")
    private String lastFourCardId;        //银行卡卡号后四位

    @JsonProperty("valid_date")
    private String validDate;            //到期时间（YYMM）

    private String cvv2;                //CVV2(RSA)

    @JsonProperty("usr_pay_agreement_id")
    private String usrPayAgreementId;    //支付协议号

    @JsonProperty("usr_busi_agreement_id")
    private String usrBusiAgreementId;    //用户业务协议号

    public PayerAgreement() {
        this.usrPayAgreementId = "";
        this.usrBusiAgreementId = "";
    }

    public String getGateId() {
        return gateId;
    }

    public void setGateId(String gateId) {
        this.gateId = gateId;
    }

    public String getLastFourCardId() {
        return lastFourCardId;
    }

    public void setLastFourCardId(String lastFourCardId) {
        this.lastFourCardId = lastFourCardId;
    }

    public String getValidDate() {
        return validDate;
    }

    public void setValidDate(String validDate) {
        this.validDate = validDate;
    }

    public String getCvv2() {
        return cvv2;
    }

    public void setCvv2(String cvv2) {
        this.cvv2 = cvv2;
    }

    public String getUsrPayAgreementId() {
        return usrPayAgreementId;
    }

    public void setUsrPayAgreementId(String usrPayAgreementId) {
        this.usrPayAgreementId = usrPayAgreementId;
    }

    public String getUsrBusiAgreementId() {
        return usrBusiAgreementId;
    }

    public void setUsrBusiAgreementId(String usrBusiAgreementId) {
        this.usrBusiAgreementId = usrBusiAgreementId;
    }
}
